/*
 * Decompiled with CFR 0.152.
 */
package net.parim.system.web.admin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.parim.common.persistence.BaseEntity;
import net.parim.system.entity.PermissionTarget;
import net.parim.system.entity.Site;
import net.parim.system.entity.UserGroup;
import net.parim.system.service.UserGroupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"${adminPath}/sys/org"})
public class OrgController {
    @Autowired
    UserGroupService userGroupService;
    @Value(value="${adminPath}")
    private String adminPath;

    @ModelAttribute
    public void getUserGroup(@RequestParam(value="id", defaultValue="-1") Long id, Model model) {
        UserGroup org;
        if (id != -1L && null != (org = this.userGroupService.findOne(id))) {
            model.addAttribute((Object)org);
        }
    }

    @RequestMapping(value={"/"})
    public String index() {
        return "admin/sys/orgIndex";
    }

    @RequestMapping(value={"/list"})
    public String list(UserGroup org, Model model) {
        List orgs = this.userGroupService.findAll(org);
        model.addAttribute("orgs", (Object)orgs);
        return "admin/sys/orgList";
    }

    @RequestMapping(value={"/properties"})
    public String properties(Model model) {
        model.addAttribute("org", (Object)new UserGroup());
        return "admin/sys/orgProperties";
    }

    @RequestMapping(value={"/save"})
    public String save(PermissionTarget permissionTarget, UserGroup userGroup, RedirectAttributes redirectAttributes, Model model) {
        if (permissionTarget.getParent().getObjectType() != null && permissionTarget.getParent().getObjectType() == PermissionTarget.ObjectType.S) {
            Site site = new Site();
            site.setId(permissionTarget.getParent().getId());
            userGroup.setParent(null);
            userGroup.setSite(site);
        }
        if (permissionTarget.getParent().getObjectType() != null && permissionTarget.getParent().getObjectType() == PermissionTarget.ObjectType.O) {
            UserGroup parent = new UserGroup();
            parent.setId(permissionTarget.getParent().getId());
            userGroup.setParent(parent);
        }
        this.userGroupService.save(userGroup);
        return "redirect:" + this.adminPath + "/sys/org/list";
    }

    @RequestMapping(value={"/delete/{id}"})
    public String delete(@PathVariable(value="id") Long id, UserGroup org, Model model) {
        this.userGroupService.delete((BaseEntity)org);
        return this.list(null, model);
    }

    @RequestMapping(value={"/treeData"})
    @ResponseBody
    public List<Map<String, Object>> treeData(@RequestParam(required=false, defaultValue="0") Long extId) {
        ArrayList mapList = Lists.newArrayList();
        List orgs = this.userGroupService.findAll();
        for (UserGroup org : orgs) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", org.getId());
            map.put("pid", org.getParent().getId());
            map.put("name", org.getName());
            mapList.add(map);
        }
        return mapList;
    }
}

