/*
 * Decompiled with CFR 0.152.
 */
package net.parim.system.web.admin;

import net.parim.system.entity.Privilege;
import net.parim.system.service.PrivilegeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"${adminPath}/sys/privilege"})
public class PrivilegeController {
    @Value(value="${adminPath}")
    String adminPath;
    @Autowired
    PrivilegeService privilegeService;

    @RequestMapping(value={"/list"})
    public String list(@PageableDefault Pageable pageable, Privilege privilege, Model model) {
        Page privs = this.privilegeService.findAllPrivileges(privilege, pageable);
        model.addAttribute("privileges", (Object)privs);
        return "admin/sys/privilegeList";
    }

    @RequestMapping(value={"/properties"})
    public String properties(Model model) {
        model.addAttribute((Object)new Privilege());
        return "admin/sys/privilegeProperties";
    }

    @RequestMapping(value={"/properties/{id}"})
    public String properties(@PathVariable Long id, Model model) {
        Privilege priv = this.privilegeService.findPrivilegeById(id);
        model.addAttribute((Object)priv);
        return "admin/sys/privilegeProperties";
    }

    @RequestMapping(value={"/save"})
    public String save(Privilege privilege, Model model) {
        this.privilegeService.savePrivilege(privilege);
        return "redirect:" + this.adminPath + "/sys/privilege/list";
    }
}

