/*
 * Decompiled with CFR 0.152.
 */
package net.parim.system.web.admin;

import net.parim.system.entity.Role;
import net.parim.system.service.RoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"${adminPath}/sys/role"})
public class RolerController {
    @Autowired
    RoleService roleService;
    @Value(value="${adminPath}")
    String adminPath;

    @RequestMapping(value={"/list"})
    public String list(@PageableDefault Pageable pageable, Role role, Model model) {
        Page roles = this.roleService.findAllRoles(role, pageable);
        model.addAttribute("roles", (Object)roles);
        return "admin/sys/roleList";
    }

    @RequestMapping(value={"/properties"})
    public String properties(Model model) {
        model.addAttribute((Object)new Role());
        return "admin/sys/roleProperties";
    }

    @RequestMapping(value={"/properties/{id}"})
    public String properties(@PathVariable Long id, Model model) {
        Role role = this.roleService.findRoleById(id);
        model.addAttribute((Object)role);
        return "admin/sys/roleProperties";
    }

    @RequestMapping(value={"/save"})
    public String save(Role role, Model model) {
        this.roleService.saveRole(role);
        return "redirect:" + this.adminPath + "/sys/role/list";
    }
}

