/*
 * Decompiled with CFR 0.152.
 */
package net.parim.system.web.admin;

import java.io.File;
import net.parim.common.config.Global;
import net.parim.common.web.BaseController;
import net.parim.system.entity.PermissionTarget;
import net.parim.system.entity.Site;
import net.parim.system.entity.User;
import net.parim.system.entity.UserGroup;
import net.parim.system.service.SiteService;
import net.parim.system.service.UserGroupService;
import net.parim.system.service.UserService;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"${adminPath}/sys/user"})
public class UserController
extends BaseController {
    @Autowired
    UserService userService;
    @Value(value="${adminPath}")
    String adminPath;
    @Autowired
    SiteService siteService;
    @Autowired
    UserGroupService userGroupService;

    @RequestMapping(value={"/"})
    public String index() {
        return "admin/sys/userIndex";
    }

    @RequestMapping(value={"/list"})
    public String list(@PageableDefault Pageable pageable, PermissionTarget permissionTarget, User user, Model model) {
        if (permissionTarget.getObjectType() == PermissionTarget.ObjectType.S) {
            Site site = new Site();
            site.setId(permissionTarget.getId());
            user.setSite(site);
        }
        if (permissionTarget.getObjectType() == PermissionTarget.ObjectType.O) {
            UserGroup userGroup = new UserGroup();
            userGroup.setId(permissionTarget.getId());
            user.setUserGroup(userGroup);
        }
        Page users = this.userService.findAll(user, pageable);
        model.addAttribute("users", (Object)users);
        return "admin/sys/userList";
    }

    @RequestMapping(value={"/properties"})
    public String properties(Model model) {
        model.addAttribute((Object)new User());
        return "admin/sys/userProperties";
    }

    @RequestMapping(value={"/properties/{id}"})
    public String properties(@PathVariable Long id, Model model) {
        User user = this.userService.findOne(id);
        model.addAttribute((Object)user);
        return "admin/sys/userProperties";
    }

    @RequestMapping(value={"/save"})
    public String save(User user, PermissionTarget pt, Model model) {
        if (pt.getParent().getObjectType() == PermissionTarget.ObjectType.S) {
            Site site = new Site(pt.getParentId());
            user.setSite(site);
        } else if (pt.getParent().getObjectType() == PermissionTarget.ObjectType.O) {
            UserGroup userGroup = this.userGroupService.findOne(pt.getParentId());
            user.setUserGroup(userGroup);
            user.setSite(userGroup.getSite());
        }
        this.userService.save(user);
        return "redirect:" + this.adminPath + "/sys/user/list";
    }

    @RequestMapping(value={"/import"}, method={RequestMethod.POST})
    public String importUser(@RequestParam(value="file") MultipartFile uploadFile, RedirectAttributes redirectAttributes) {
        try {
            String suffix = uploadFile.getOriginalFilename().substring(uploadFile.getOriginalFilename().lastIndexOf("."));
            File file = new File(Global.getConfig((String)"userfiles.basedir") + File.separator + System.currentTimeMillis() + suffix);
            FileUtils.writeByteArrayToFile((File)file, (byte[])uploadFile.getBytes());
        }
        catch (Exception e) {
            this.addError(redirectAttributes, "user.import.error", new String[]{uploadFile.getOriginalFilename()});
        }
        this.addSuccess(redirectAttributes, "user.import.success", new String[]{uploadFile.getOriginalFilename()});
        return "redirect:" + this.adminPath + "/sys/user/list";
    }
}

