/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.odps.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowTablesStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsAddStatisticStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsAnalyzeTableStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsInsert;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsInsertStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsReadStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsRemoveStatisticStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsSetLabelStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsShowPartitionsStmt;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsShowStatisticStmt;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsStatisticClause;
import com.alibaba.druid.sql.dialect.odps.parser.OdpsCreateTableParser;
import com.alibaba.druid.sql.dialect.odps.parser.OdpsExprParser;
import com.alibaba.druid.sql.dialect.odps.parser.OdpsLexer;
import com.alibaba.druid.sql.dialect.odps.parser.OdpsSelectParser;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;
import java.util.List;

public class OdpsStatementParser
extends SQLStatementParser {
    public OdpsStatementParser(String sql) {
        super(new OdpsLexer(sql, true, true), "odps");
        this.exprParser = new OdpsExprParser(this.lexer);
        this.lexer.nextToken();
    }

    public OdpsStatementParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    @Override
    public SQLSelectStatement parseSelect() {
        OdpsSelectParser selectParser = new OdpsSelectParser(this.exprParser);
        return new SQLSelectStatement(selectParser.select(), "odps");
    }

    @Override
    public SQLCreateTableStatement parseCreateTable() {
        OdpsCreateTableParser parser = new OdpsCreateTableParser(this.exprParser);
        return parser.parseCrateTable();
    }

    @Override
    public SQLCreateTableParser getSQLCreateTableParser() {
        return new OdpsCreateTableParser(this.exprParser);
    }

    @Override
    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        if (this.lexer.token() == Token.FROM) {
            SQLStatement stmt = this.parseInsert();
            statementList.add(stmt);
            return true;
        }
        if (this.identifierEquals("ANALYZE")) {
            this.lexer.nextToken();
            this.accept(Token.TABLE);
            OdpsAnalyzeTableStatement stmt = new OdpsAnalyzeTableStatement();
            SQLName table = this.exprParser.name();
            stmt.setTable(table);
            if (this.lexer.token() == Token.PARTITION) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                this.parseAssignItems(stmt.getPartition(), stmt);
                this.accept(Token.RPAREN);
            }
            this.accept(Token.COMPUTE);
            this.acceptIdentifier("STATISTICS");
            statementList.add(stmt);
            return true;
        }
        if (this.identifierEquals("ADD")) {
            this.lexer.nextToken();
            if (this.identifierEquals("STATISTIC")) {
                this.lexer.nextToken();
                OdpsAddStatisticStatement stmt = new OdpsAddStatisticStatement();
                stmt.setTable(this.exprParser.name());
                stmt.setStatisticClause(this.parseStaticClause());
                statementList.add(stmt);
                return true;
            }
            throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
        }
        if (this.identifierEquals("REMOVE")) {
            this.lexer.nextToken();
            if (this.identifierEquals("STATISTIC")) {
                this.lexer.nextToken();
                OdpsRemoveStatisticStatement stmt = new OdpsRemoveStatisticStatement();
                stmt.setTable(this.exprParser.name());
                stmt.setStatisticClause(this.parseStaticClause());
                statementList.add(stmt);
                return true;
            }
            throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
        }
        if (this.identifierEquals("READ")) {
            this.lexer.nextToken();
            OdpsReadStatement stmt = new OdpsReadStatement();
            stmt.setTable(this.exprParser.name());
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                this.exprParser.names(stmt.getColumns(), stmt);
                this.accept(Token.RPAREN);
            }
            if (this.lexer.token() == Token.PARTITION) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                this.parseAssignItems(stmt.getPartition(), stmt);
                this.accept(Token.RPAREN);
            }
            if (this.lexer.token() == Token.LITERAL_INT) {
                stmt.setRowCount(this.exprParser.primary());
            }
            statementList.add(stmt);
            return true;
        }
        return false;
    }

    protected OdpsStatisticClause parseStaticClause() {
        if (this.identifierEquals("TABLE_COUNT")) {
            this.lexer.nextToken();
            return new OdpsStatisticClause.TableCount();
        }
        if (this.identifierEquals("NULL_VALUE")) {
            this.lexer.nextToken();
            OdpsStatisticClause.NullValue null_value = new OdpsStatisticClause.NullValue();
            null_value.setColumn(this.exprParser.name());
            return null_value;
        }
        if (this.identifierEquals("COLUMN_SUM")) {
            this.lexer.nextToken();
            OdpsStatisticClause.ColumnSum column_sum = new OdpsStatisticClause.ColumnSum();
            column_sum.setColumn(this.exprParser.name());
            return column_sum;
        }
        if (this.identifierEquals("COLUMN_MAX")) {
            this.lexer.nextToken();
            OdpsStatisticClause.ColumnMax column_max = new OdpsStatisticClause.ColumnMax();
            column_max.setColumn(this.exprParser.name());
            return column_max;
        }
        if (this.identifierEquals("COLUMN_MIN")) {
            this.lexer.nextToken();
            OdpsStatisticClause.ColumnMin column_min = new OdpsStatisticClause.ColumnMin();
            column_min.setColumn(this.exprParser.name());
            return column_min;
        }
        if (this.identifierEquals("EXPRESSION_CONDITION")) {
            this.lexer.nextToken();
            OdpsStatisticClause.ExpressionCondition expr_condition = new OdpsStatisticClause.ExpressionCondition();
            expr_condition.setExpr(this.exprParser.expr());
            return expr_condition;
        }
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
    }

    @Override
    public SQLStatement parseInsert() {
        OdpsInsertStatement stmt = new OdpsInsertStatement();
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            SQLSelectParser selectParser = this.createSQLSelectParser();
            SQLSelect select = selectParser.select();
            this.accept(Token.RPAREN);
            String alias = this.lexer.stringVal();
            this.accept(Token.IDENTIFIER);
            SQLSubqueryTableSource from = new SQLSubqueryTableSource(select, alias);
            stmt.setFrom(from);
        }
        do {
            OdpsInsert insert = this.parseOdpsInsert();
            stmt.getItems().add(insert);
        } while (this.lexer.token() == Token.INSERT);
        return stmt;
    }

    public OdpsInsert parseOdpsInsert() {
        OdpsInsert insert = new OdpsInsert();
        if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
            insert.addBeforeComment(this.lexer.readAndResetComments());
        }
        SQLSelectParser selectParser = this.createSQLSelectParser();
        this.accept(Token.INSERT);
        if (this.lexer.token() == Token.INTO) {
            this.lexer.nextToken();
        } else {
            this.accept(Token.OVERWRITE);
            insert.setOverwrite(true);
        }
        this.accept(Token.TABLE);
        insert.setTableSource(this.exprParser.name());
        if (this.lexer.token() == Token.PARTITION) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            while (true) {
                SQLAssignItem ptExpr = new SQLAssignItem();
                ptExpr.setTarget(this.exprParser.name());
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                    SQLExpr ptValue = this.exprParser.expr();
                    ptExpr.setValue(ptValue);
                }
                insert.getPartitions().add(ptExpr);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        SQLSelect query = selectParser.select();
        insert.setQuery(query);
        return insert;
    }

    @Override
    public SQLStatement parseShow() {
        this.accept(Token.SHOW);
        if (this.identifierEquals("PARTITIONS")) {
            this.lexer.nextToken();
            OdpsShowPartitionsStmt stmt = new OdpsShowPartitionsStmt();
            SQLExpr expr = this.exprParser.expr();
            stmt.setTableSource(new SQLExprTableSource(expr));
            return stmt;
        }
        if (this.identifierEquals("STATISTIC")) {
            this.lexer.nextToken();
            OdpsShowStatisticStmt stmt = new OdpsShowStatisticStmt();
            SQLExpr expr = this.exprParser.expr();
            stmt.setTableSource(new SQLExprTableSource(expr));
            return stmt;
        }
        if (this.identifierEquals("TABLES")) {
            this.lexer.nextToken();
            SQLShowTablesStatement stmt = new SQLShowTablesStatement();
            if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
                stmt.setDatabase(this.exprParser.name());
            }
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                stmt.setLike(this.exprParser.expr());
            }
            return stmt;
        }
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
    }

    @Override
    public SQLStatement parseSet() {
        List<String> comments = null;
        if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
            comments = this.lexer.readAndResetComments();
        }
        this.accept(Token.SET);
        if (this.identifierEquals("LABEL")) {
            OdpsSetLabelStatement stmt = new OdpsSetLabelStatement();
            if (comments != null) {
                stmt.addBeforeComment(comments);
            }
            this.lexer.nextToken();
            stmt.setLabel(this.lexer.stringVal());
            this.lexer.nextToken();
            this.accept(Token.TO);
            if (this.lexer.token() == Token.USER) {
                this.lexer.nextToken();
                SQLName name = this.exprParser.name();
                stmt.setUser(name);
                return stmt;
            }
            this.accept(Token.TABLE);
            SQLName expr = this.exprParser.name();
            stmt.setTable(new SQLExprTableSource(expr));
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                this.exprParser.names(stmt.getColumns(), stmt);
                this.accept(Token.RPAREN);
            }
            return stmt;
        }
        SQLSetStatement stmt = new SQLSetStatement(this.getDbType());
        if (comments != null) {
            stmt.addBeforeComment(comments);
        }
        this.parseAssignItems(stmt.getItems(), stmt);
        return stmt;
    }
}

