/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.cache.memory;

import com.ibatis.sqlmap.client.SqlMapException;
import java.util.HashMap;
import java.util.Map;

public final class MemoryCacheLevel {
    private static Map cacheLevelMap = new HashMap();
    public static final MemoryCacheLevel WEAK = new MemoryCacheLevel("WEAK");
    public static final MemoryCacheLevel SOFT = new MemoryCacheLevel("SOFT");
    public static final MemoryCacheLevel STRONG = new MemoryCacheLevel("STRONG");
    private String referenceType;

    private MemoryCacheLevel(String type) {
        this.referenceType = type;
    }

    public String getReferenceType() {
        return this.referenceType;
    }

    public static MemoryCacheLevel getByReferenceType(String refType) {
        MemoryCacheLevel cacheLevel = (MemoryCacheLevel)cacheLevelMap.get(refType);
        if (cacheLevel == null) {
            throw new SqlMapException("Error getting CacheLevel (reference type) for name: '" + refType + "'.");
        }
        return cacheLevel;
    }

    static {
        cacheLevelMap.put(MemoryCacheLevel.WEAK.referenceType, WEAK);
        cacheLevelMap.put(MemoryCacheLevel.SOFT.referenceType, SOFT);
        cacheLevelMap.put(MemoryCacheLevel.STRONG.referenceType, STRONG);
    }
}

