/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.impl;

import com.ibatis.common.jdbc.exception.NestedSQLException;
import com.ibatis.common.util.PaginatedList;
import com.ibatis.sqlmap.client.SqlMapSession;
import com.ibatis.sqlmap.client.event.RowHandler;
import com.ibatis.sqlmap.engine.execution.BatchException;
import com.ibatis.sqlmap.engine.execution.SqlExecutor;
import com.ibatis.sqlmap.engine.impl.ExtendedSqlMapClient;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.scope.SessionScope;
import com.ibatis.sqlmap.engine.transaction.Transaction;
import com.ibatis.sqlmap.engine.transaction.TransactionException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class SqlMapSessionImpl
implements SqlMapSession {
    protected SqlMapExecutorDelegate delegate;
    protected SessionScope session;
    protected boolean closed;

    public SqlMapSessionImpl(ExtendedSqlMapClient client) {
        this.delegate = client.getDelegate();
        this.session = this.delegate.popSession();
        this.session.setSqlMapClient(client);
        this.session.setSqlMapExecutor(client);
        this.session.setSqlMapTxMgr(client);
        this.closed = false;
    }

    public void open() {
        this.session.setSqlMapTxMgr(this);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        if (this.delegate != null && this.session != null) {
            this.delegate.pushSession(this.session);
        }
        if (this.session != null) {
            this.session = null;
        }
        if (this.delegate != null) {
            this.delegate = null;
        }
        if (!this.closed) {
            this.closed = true;
        }
    }

    public Object insert(String id, Object param) throws SQLException {
        return this.delegate.insert(this.session, id, param);
    }

    public Object insert(String id) throws SQLException {
        return this.insert(id, null);
    }

    public int update(String id, Object param) throws SQLException {
        return this.delegate.update(this.session, id, param);
    }

    public int update(String id) throws SQLException {
        return this.update(id, null);
    }

    public int delete(String id, Object param) throws SQLException {
        return this.delegate.delete(this.session, id, param);
    }

    public int delete(String id) throws SQLException {
        return this.delete(id, null);
    }

    public Object queryForObject(String id, Object paramObject) throws SQLException {
        return this.delegate.queryForObject(this.session, id, paramObject);
    }

    public Object queryForObject(String id) throws SQLException {
        return this.queryForObject(id, null);
    }

    public Object queryForObject(String id, Object paramObject, Object resultObject) throws SQLException {
        return this.delegate.queryForObject(this.session, id, paramObject, resultObject);
    }

    public List queryForList(String id, Object paramObject) throws SQLException {
        return this.delegate.queryForList(this.session, id, paramObject);
    }

    public List queryForList(String id) throws SQLException {
        return this.queryForList(id, null);
    }

    public List queryForList(String id, Object paramObject, int skip, int max) throws SQLException {
        return this.delegate.queryForList(this.session, id, paramObject, skip, max);
    }

    public List queryForList(String id, int skip, int max) throws SQLException {
        return this.queryForList(id, null, skip, max);
    }

    public PaginatedList queryForPaginatedList(String id, Object paramObject, int pageSize) throws SQLException {
        return this.delegate.queryForPaginatedList(this.session, id, paramObject, pageSize);
    }

    public PaginatedList queryForPaginatedList(String id, int pageSize) throws SQLException {
        return this.queryForPaginatedList(id, null, pageSize);
    }

    public Map queryForMap(String id, Object paramObject, String keyProp) throws SQLException {
        return this.delegate.queryForMap(this.session, id, paramObject, keyProp);
    }

    public Map queryForMap(String id, Object paramObject, String keyProp, String valueProp) throws SQLException {
        return this.delegate.queryForMap(this.session, id, paramObject, keyProp, valueProp);
    }

    public void queryWithRowHandler(String id, Object paramObject, RowHandler rowHandler) throws SQLException {
        this.delegate.queryWithRowHandler(this.session, id, paramObject, rowHandler);
    }

    public void queryWithRowHandler(String id, RowHandler rowHandler) throws SQLException {
        this.queryWithRowHandler(id, null, rowHandler);
    }

    public void startTransaction() throws SQLException {
        this.delegate.startTransaction(this.session);
    }

    public void startTransaction(int transactionIsolation) throws SQLException {
        this.delegate.startTransaction(this.session, transactionIsolation);
    }

    public void commitTransaction() throws SQLException {
        this.delegate.commitTransaction(this.session);
    }

    public void endTransaction() throws SQLException {
        this.delegate.endTransaction(this.session);
    }

    public void startBatch() throws SQLException {
        this.delegate.startBatch(this.session);
    }

    public int executeBatch() throws SQLException {
        return this.delegate.executeBatch(this.session);
    }

    public List executeBatchDetailed() throws SQLException, BatchException {
        return this.delegate.executeBatchDetailed(this.session);
    }

    public void setUserConnection(Connection connection) throws SQLException {
        this.delegate.setUserProvidedTransaction(this.session, connection);
    }

    public Connection getUserConnection() throws SQLException {
        return this.getCurrentConnection();
    }

    public Connection getCurrentConnection() throws SQLException {
        try {
            Connection conn = null;
            Transaction trans = this.delegate.getTransaction(this.session);
            if (trans != null) {
                conn = trans.getConnection();
            }
            return conn;
        }
        catch (TransactionException e) {
            throw new NestedSQLException("Error getting Connection from Transaction.  Cause: " + e, e);
        }
    }

    public DataSource getDataSource() {
        return this.delegate.getDataSource();
    }

    public MappedStatement getMappedStatement(String id) {
        return this.delegate.getMappedStatement(id);
    }

    public boolean isLazyLoadingEnabled() {
        return this.delegate.isLazyLoadingEnabled();
    }

    public boolean isEnhancementEnabled() {
        return this.delegate.isEnhancementEnabled();
    }

    public SqlExecutor getSqlExecutor() {
        return this.delegate.getSqlExecutor();
    }

    public SqlMapExecutorDelegate getDelegate() {
        return this.delegate;
    }
}

