/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.mapper.mapperhelper;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import tk.mybatis.mapper.entity.EntityField;

public class FieldHelper {
    public static List<EntityField> getFields(Class<?> entityClass) {
        List<EntityField> fields = FieldHelper._getFields(entityClass, null, null);
        List<EntityField> properties = FieldHelper._getProperties(entityClass);
        HashSet usedSet = new HashSet();
        block0: for (EntityField field : fields) {
            for (EntityField property : properties) {
                if (usedSet.contains(property) || !field.getName().equals(property.getName())) continue;
                field.setJavaType(property.getJavaType());
                continue block0;
            }
        }
        return fields;
    }

    public static List<EntityField> getAll(Class<?> entityClass) {
        List<EntityField> fields = FieldHelper._getFields(entityClass, null, null);
        List<EntityField> properties = FieldHelper._getProperties(entityClass);
        ArrayList<EntityField> all = new ArrayList<EntityField>();
        HashSet<EntityField> usedSet = new HashSet<EntityField>();
        for (EntityField field : fields) {
            for (EntityField property : properties) {
                if (usedSet.contains(property) || !field.getName().equals(property.getName())) continue;
                field.copyFromPropertyDescriptor(property);
                usedSet.add(property);
                break;
            }
            all.add(field);
        }
        for (EntityField property : properties) {
            if (usedSet.contains(property)) continue;
            all.add(property);
        }
        return all;
    }

    private static List<EntityField> _getFields(Class<?> entityClass, List<EntityField> fieldList, Integer level) {
        if (fieldList == null) {
            fieldList = new ArrayList<EntityField>();
        }
        if (level == null) {
            level = 0;
        }
        if (entityClass.equals(Object.class)) {
            return fieldList;
        }
        Field[] fields = entityClass.getDeclaredFields();
        int index = 0;
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (Modifier.isStatic(field.getModifiers())) continue;
            if (level != 0) {
                fieldList.add(index, new EntityField(field, null));
                ++index;
                continue;
            }
            fieldList.add(new EntityField(field, null));
        }
        Class<?> superClass = entityClass.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class) && (superClass.isAnnotationPresent(Entity.class) || !Map.class.isAssignableFrom(superClass) && !Collection.class.isAssignableFrom(superClass))) {
            level = level + 1;
            return FieldHelper._getFields(entityClass.getSuperclass(), fieldList, level);
        }
        return fieldList;
    }

    private static List<EntityField> _getProperties(Class<?> entityClass) {
        PropertyDescriptor[] descriptors;
        ArrayList<EntityField> entityFields = new ArrayList<EntityField>();
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(entityClass);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        for (PropertyDescriptor desc : descriptors = beanInfo.getPropertyDescriptors()) {
            if (desc.getName().equals("class")) continue;
            entityFields.add(new EntityField(null, desc));
        }
        return entityFields;
    }
}

