/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.io;

import com.dianping.cat.configuration.ClientConfigManager;
import com.dianping.cat.configuration.KVConfig;
import com.dianping.cat.message.internal.MessageIdFactory;
import com.dianping.cat.message.io.TcpSocketSender;
import com.dianping.cat.message.spi.MessageQueue;
import com.site.helper.JsonBuilder;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.codehaus.plexus.logging.Logger;
import org.unidal.helper.Files;
import org.unidal.helper.Splitters;
import org.unidal.helper.Threads;
import org.unidal.helper.Urls;
import org.unidal.lookup.util.StringUtils;
import org.unidal.tuple.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelManager
implements Threads.Task {
    private ClientConfigManager m_configManager;
    private Bootstrap m_bootstrap;
    private Logger m_logger;
    private boolean m_active = true;
    private int m_retriedTimes = 0;
    private int m_count = -10;
    private volatile double m_sample = 1.0;
    private MessageQueue m_queue;
    private ChannelHolder m_activeChannelHolder;
    private MessageIdFactory m_idfactory;
    private JsonBuilder m_jsonBuilder = new JsonBuilder();

    public ChannelManager(Logger logger, List<InetSocketAddress> serverAddresses, MessageQueue queue, ClientConfigManager configManager, MessageIdFactory idFactory) {
        this.m_logger = logger;
        this.m_queue = queue;
        this.m_configManager = configManager;
        this.m_idfactory = idFactory;
        NioEventLoopGroup group = new NioEventLoopGroup(1, new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                return t;
            }
        });
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)bootstrap.group((EventLoopGroup)group)).channel(NioSocketChannel.class);
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
            }
        });
        this.m_bootstrap = bootstrap;
        String serverConfig = this.loadServerConfig();
        if (StringUtils.isNotEmpty((String)serverConfig)) {
            List<InetSocketAddress> configedAddresses = this.parseSocketAddress(serverConfig);
            ChannelHolder holder = this.initChannel(configedAddresses, serverConfig);
            if (holder != null) {
                this.m_activeChannelHolder = holder;
            } else {
                this.m_activeChannelHolder = new ChannelHolder();
                this.m_activeChannelHolder.setServerAddresses(configedAddresses);
            }
        } else {
            ChannelHolder holder = this.initChannel(serverAddresses, null);
            if (holder != null) {
                this.m_activeChannelHolder = holder;
            } else {
                this.m_activeChannelHolder = new ChannelHolder();
                this.m_activeChannelHolder.setServerAddresses(serverAddresses);
                this.m_logger.error("error when init cat module due to error config xml in /data/appdatas/cat/client.xml");
            }
        }
    }

    public ChannelFuture channel() {
        if (this.m_activeChannelHolder != null) {
            return this.m_activeChannelHolder.getActiveFuture();
        }
        return null;
    }

    private void checkServerChanged() {
        String servers;
        List<InetSocketAddress> serverAddresses;
        ChannelHolder newHolder;
        Pair<Boolean, String> pair;
        if (this.shouldCheckServerConfig(++this.m_count) && ((Boolean)(pair = this.routerConfigChanged()).getKey()).booleanValue() && (newHolder = this.initChannel(serverAddresses = this.parseSocketAddress(servers = (String)pair.getValue()), servers)) != null) {
            if (newHolder.isConnectChanged()) {
                ChannelHolder last = this.m_activeChannelHolder;
                this.m_activeChannelHolder = newHolder;
                this.closeChannelHolder(last);
                this.m_logger.info("switch active channel to " + this.m_activeChannelHolder);
            } else {
                this.m_activeChannelHolder = newHolder;
            }
        }
    }

    private void closeChannel(ChannelFuture channel) {
        try {
            if (channel != null) {
                this.m_logger.info("close channel " + channel.channel().remoteAddress());
                channel.channel().close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeChannelHolder(ChannelHolder channelHolder) {
        try {
            ChannelFuture channel = channelHolder.getActiveFuture();
            this.closeChannel(channel);
            channelHolder.setActiveIndex(-1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ChannelFuture createChannel(InetSocketAddress address) {
        block3: {
            ChannelFuture future = null;
            try {
                future = this.m_bootstrap.connect((SocketAddress)address);
                future.awaitUninterruptibly(100L, TimeUnit.MILLISECONDS);
                if (future.isSuccess()) {
                    this.m_logger.info("Connected to CAT server at " + address);
                    return future;
                }
                this.m_logger.error("Error when try connecting to " + address);
                this.closeChannel(future);
            }
            catch (Throwable e) {
                this.m_logger.error("Error when connect server " + address.getAddress(), e);
                if (future == null) break block3;
                this.closeChannel(future);
            }
        }
        return null;
    }

    private void doubleCheckActiveServer(ChannelFuture activeFuture) {
        try {
            if (this.isChannelStalled(activeFuture) || this.isChannelDisabled(activeFuture)) {
                this.closeChannelHolder(this.m_activeChannelHolder);
            }
        }
        catch (Throwable e) {
            this.m_logger.error(e.getMessage(), e);
        }
    }

    public String getName() {
        return "TcpSocketSender-ChannelManager";
    }

    public double getSample() {
        return this.m_sample;
    }

    private ChannelHolder initChannel(List<InetSocketAddress> addresses, String serverConfig) {
        try {
            int len = addresses.size();
            for (int i = 0; i < len; ++i) {
                InetSocketAddress address = addresses.get(i);
                String hostAddress = address.getAddress().getHostAddress();
                ChannelHolder holder = null;
                if (this.m_activeChannelHolder != null && hostAddress.equals(this.m_activeChannelHolder.getIp())) {
                    holder = new ChannelHolder();
                    holder.setActiveFuture(this.m_activeChannelHolder.getActiveFuture()).setConnectChanged(false);
                } else {
                    ChannelFuture future = this.createChannel(address);
                    if (future != null) {
                        holder = new ChannelHolder();
                        holder.setActiveFuture(future).setConnectChanged(true);
                    }
                }
                if (holder == null) continue;
                holder.setActiveIndex(i).setIp(hostAddress);
                holder.setActiveServerConfig(serverConfig).setServerAddresses(addresses);
                this.m_logger.info("success when init CAT server, new active holder" + holder.toString());
                return holder;
            }
        }
        catch (Exception e) {
            this.m_logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            StringBuilder sb = new StringBuilder();
            for (InetSocketAddress address : addresses) {
                sb.append(address.toString()).append(";");
            }
            this.m_logger.info("Error when init CAT server " + sb.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean isChannelDisabled(ChannelFuture activeFuture) {
        return activeFuture != null && !activeFuture.channel().isOpen();
    }

    private boolean isChannelStalled(ChannelFuture activeFuture) {
        boolean stalled;
        ++this.m_retriedTimes;
        int size = this.m_queue.size();
        boolean bl = stalled = activeFuture != null && size >= TcpSocketSender.getQueueSize() - 10;
        if (stalled) {
            if (this.m_retriedTimes >= 5) {
                this.m_retriedTimes = 0;
                return true;
            }
            return false;
        }
        return false;
    }

    private String loadServerConfig() {
        try {
            String url = this.m_configManager.getServerConfigUrl();
            InputStream inputstream = Urls.forIO().readTimeout(2000).connectTimeout(1000).openStream(url);
            String content = Files.forIO().readFrom(inputstream, "utf-8");
            KVConfig routerConfig = (KVConfig)this.m_jsonBuilder.parse(content.trim(), KVConfig.class);
            String current = routerConfig.getValue("routers");
            this.m_sample = Double.valueOf(routerConfig.getValue("sample").trim());
            return current.trim();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private List<InetSocketAddress> parseSocketAddress(String content) {
        try {
            List strs = Splitters.by((String)";").noEmptyItem().split(content);
            ArrayList<InetSocketAddress> address = new ArrayList<InetSocketAddress>();
            for (String str : strs) {
                List items = Splitters.by((String)":").noEmptyItem().split(str);
                address.add(new InetSocketAddress((String)items.get(0), Integer.parseInt((String)items.get(1))));
            }
            return address;
        }
        catch (Exception e) {
            this.m_logger.error(e.getMessage(), (Throwable)e);
            return new ArrayList<InetSocketAddress>();
        }
    }

    private void reconnectDefaultServer(ChannelFuture activeFuture, List<InetSocketAddress> serverAddresses) {
        try {
            int reconnectServers = this.m_activeChannelHolder.getActiveIndex();
            if (reconnectServers == -1) {
                reconnectServers = serverAddresses.size();
            }
            for (int i = 0; i < reconnectServers; ++i) {
                ChannelFuture future = this.createChannel(serverAddresses.get(i));
                if (future == null) continue;
                ChannelFuture lastFuture = activeFuture;
                this.m_activeChannelHolder.setActiveFuture(future);
                this.m_activeChannelHolder.setActiveIndex(i);
                this.closeChannel(lastFuture);
                break;
            }
        }
        catch (Throwable e) {
            this.m_logger.error(e.getMessage(), e);
        }
    }

    private Pair<Boolean, String> routerConfigChanged() {
        String current = this.loadServerConfig();
        if (!StringUtils.isEmpty((String)current) && !current.equals(this.m_activeChannelHolder.getActiveServerConfig())) {
            return new Pair((Object)true, (Object)current);
        }
        return new Pair((Object)false, (Object)current);
    }

    public void run() {
        while (this.m_active) {
            this.m_idfactory.saveMark();
            this.checkServerChanged();
            ChannelFuture activeFuture = this.m_activeChannelHolder.getActiveFuture();
            List<InetSocketAddress> serverAddresses = this.m_activeChannelHolder.getServerAddresses();
            this.doubleCheckActiveServer(activeFuture);
            this.reconnectDefaultServer(activeFuture, serverAddresses);
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean shouldCheckServerConfig(int count) {
        int duration = 30;
        return count % duration == 0 || this.m_activeChannelHolder.getActiveIndex() == -1;
    }

    public void shutdown() {
        this.m_active = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChannelHolder {
        private ChannelFuture m_activeFuture;
        private int m_activeIndex = -1;
        private String m_activeServerConfig;
        private List<InetSocketAddress> m_serverAddresses;
        private String m_ip;
        private boolean m_connectChanged;

        public ChannelFuture getActiveFuture() {
            return this.m_activeFuture;
        }

        public int getActiveIndex() {
            return this.m_activeIndex;
        }

        public String getActiveServerConfig() {
            return this.m_activeServerConfig;
        }

        public String getIp() {
            return this.m_ip;
        }

        public List<InetSocketAddress> getServerAddresses() {
            return this.m_serverAddresses;
        }

        public boolean isConnectChanged() {
            return this.m_connectChanged;
        }

        public ChannelHolder setActiveFuture(ChannelFuture activeFuture) {
            this.m_activeFuture = activeFuture;
            return this;
        }

        public ChannelHolder setActiveIndex(int activeIndex) {
            this.m_activeIndex = activeIndex;
            return this;
        }

        public ChannelHolder setActiveServerConfig(String activeServerConfig) {
            this.m_activeServerConfig = activeServerConfig;
            return this;
        }

        public ChannelHolder setConnectChanged(boolean connectChanged) {
            this.m_connectChanged = connectChanged;
            return this;
        }

        public ChannelHolder setIp(String ip) {
            this.m_ip = ip;
            return this;
        }

        public ChannelHolder setServerAddresses(List<InetSocketAddress> serverAddresses) {
            this.m_serverAddresses = serverAddresses;
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("active future :").append(this.m_activeFuture.channel().remoteAddress());
            sb.append(" index:").append(this.m_activeIndex);
            sb.append(" ip:").append(this.m_ip);
            sb.append(" server config:").append(this.m_activeServerConfig);
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ClientMessageHandler
    extends SimpleChannelInboundHandler<Object> {
        protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
            ChannelManager.this.m_logger.info("receiver msg from server:" + msg);
        }
    }
}

