/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLDeclareItem;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLParameter;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.FnvHash;

public class SQLIdentifierExpr
extends SQLExprImpl
implements SQLName {
    protected String name;
    private long hashCode64;
    private SQLObject resolvedColumn;
    private SQLObject resolvedOwnerObject;

    public SQLIdentifierExpr() {
    }

    public SQLIdentifierExpr(String name) {
        this.name = name;
    }

    public SQLIdentifierExpr(String name, long hash_lower) {
        this.name = name;
        this.hashCode64 = hash_lower;
    }

    @Override
    public String getSimpleName() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.hashCode64 = 0L;
        if (this.parent instanceof SQLPropertyExpr) {
            SQLPropertyExpr propertyExpr = (SQLPropertyExpr)this.parent;
            propertyExpr.computeHashCode64();
        }
    }

    @Override
    public long nameHashCode64() {
        return this.hashCode64();
    }

    @Override
    public long hashCode64() {
        if (this.hashCode64 == 0L && this.name != null) {
            this.hashCode64 = FnvHash.hashCode64(this.name);
        }
        return this.hashCode64;
    }

    @Override
    public void output(StringBuffer buf) {
        buf.append(this.name);
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public int hashCode() {
        long value = this.hashCode64();
        return (int)(value ^ value >>> 32);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SQLIdentifierExpr)) {
            return false;
        }
        SQLIdentifierExpr other = (SQLIdentifierExpr)obj;
        return this.hashCode64() == other.hashCode64();
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public SQLIdentifierExpr clone() {
        SQLIdentifierExpr x = new SQLIdentifierExpr(this.name, this.hashCode64);
        x.resolvedColumn = this.resolvedColumn;
        x.resolvedOwnerObject = this.resolvedOwnerObject;
        return x;
    }

    public SQLIdentifierExpr simplify() {
        String normalized = SQLUtils.normalize(this.name);
        if (normalized != this.name) {
            return new SQLIdentifierExpr(normalized, this.hashCode64);
        }
        return this;
    }

    public String normalizedName() {
        return SQLUtils.normalize(this.name);
    }

    public SQLColumnDefinition getResolvedColumn() {
        if (this.resolvedColumn instanceof SQLColumnDefinition) {
            return (SQLColumnDefinition)this.resolvedColumn;
        }
        return null;
    }

    public SQLObject getResolvedColumnObject() {
        return this.resolvedColumn;
    }

    public void setResolvedColumn(SQLColumnDefinition resolvedColumn) {
        this.resolvedColumn = resolvedColumn;
    }

    public SQLTableSource getResolvedTableSource() {
        if (this.resolvedOwnerObject instanceof SQLTableSource) {
            return (SQLTableSource)this.resolvedOwnerObject;
        }
        return null;
    }

    public void setResolvedTableSource(SQLTableSource resolvedTableSource) {
        this.resolvedOwnerObject = resolvedTableSource;
    }

    public SQLObject getResolvedOwnerObject() {
        return this.resolvedOwnerObject;
    }

    public void setResolvedOwnerObject(SQLObject resolvedOwnerObject) {
        this.resolvedOwnerObject = resolvedOwnerObject;
    }

    public SQLParameter getResolvedParameter() {
        if (this.resolvedColumn instanceof SQLParameter) {
            return (SQLParameter)this.resolvedColumn;
        }
        return null;
    }

    public void setResolvedParameter(SQLParameter resolvedParameter) {
        this.resolvedColumn = resolvedParameter;
    }

    public SQLDeclareItem getResolvedDeclareItem() {
        if (this.resolvedColumn instanceof SQLDeclareItem) {
            return (SQLDeclareItem)this.resolvedColumn;
        }
        return null;
    }

    public void setResolvedDeclareItem(SQLDeclareItem resolvedDeclareItem) {
        this.resolvedColumn = resolvedDeclareItem;
    }

    @Override
    public SQLDataType computeDataType() {
        SQLColumnDefinition resolvedColumn = this.getResolvedColumn();
        if (resolvedColumn != null) {
            return resolvedColumn.getDataType();
        }
        if (this.resolvedOwnerObject != null && this.resolvedOwnerObject instanceof SQLSubqueryTableSource) {
            SQLSelect select = ((SQLSubqueryTableSource)this.resolvedOwnerObject).getSelect();
            SQLSelectQueryBlock queryBlock = select.getFirstQueryBlock();
            if (queryBlock == null) {
                return null;
            }
            SQLSelectItem selectItem = queryBlock.findSelectItem(this.nameHashCode64());
            if (selectItem != null) {
                return selectItem.computeDataType();
            }
        }
        return null;
    }

    public boolean nameEquals(String name) {
        return SQLUtils.nameEquals(this.name, name);
    }
}

