/*
 * Copyright 2017 Baidu, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.iotdm.model.v3.schema;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;

import java.util.List;

/**
 * Represent the request of creating a schema.
 */
public class SchemaCreateRequest extends AbstractBceRequest {

    private String name;

    private String description;

    private List<SchemaProperty> properties;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SchemaCreateRequest withName(String name) {
        setName(name);
        return this;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SchemaCreateRequest withDescription(String description) {
        setDescription(description);
        return this;
    }

    public List<SchemaProperty> getProperties() {
        return properties;
    }

    public void setProperties(List<SchemaProperty> properties) {
        this.properties = properties;
    }

    public SchemaCreateRequest withProperties(List<SchemaProperty> properties) {
        setProperties(properties);
        return this;
    }

    @Override
    public SchemaCreateRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }

}
