package com.baidubce.services.nat.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * The request for creating a snat rule.
 */
@Setter
@Getter
public class CreateSnatRuleRequest extends AbstractBceRequest {

    /**
     * An ASCII string whose length is less than 64.
     *
     * The request will be idempotent if clientToken is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/BCC/API.html#.E5.B9.82.E7.AD.89.E6.80.A7">
     *     BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;

    /**
     * The nat id of the specified snat
     */
    @JsonIgnore
    private String natId;

    /**
     * The name of the snat rule
     */
    private String ruleName;

    /**
     * The source cidr
     */
    private String sourceCIDR;

    /**
     * The list of the public ip addresses
     */
    private List<String> publicIpsAddress;

    /**
     * Configure request credential for the request.
     *
     * @param credentials a valid instance of BceCredentials.
     * @return CreateSnatRuleRequest with credentials.
     */
    @Override
    public CreateSnatRuleRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
