package com.baidubce.services.route.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;

/**
 * Created by zhangjing60 on 17/8/2.
 */
public class DeleteRouteRequest extends AbstractBceRequest {

    /**
     * the API version number
     */
    private String version;

    /**
     * An ASCII string whose length is less than 64.
     *
     * The request will be idempotent if clientToken is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     *
     */
    private String clientToken;

    /**
     * the route rule id
     */
    private String routeRuleId;

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
    public String getClientToken() {
        return clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getRouteRuleId() {
        return routeRuleId;
    }

    public void setRouteRuleId(String routeRuleId) {
        this.routeRuleId = routeRuleId;
    }

    /**
     * Configure the version for the request
     * @param version the API version number
     * @return DeleteRouteRequest with version
     */
    public DeleteRouteRequest withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Configure optional client token for the request. The request will be idempotent if client token is provided.
     * @param clientToken An ASCII string whose length is less than 64.
     *                    See more detail at
     * @return  DeleteRouteRequest with client token
     *
     */
    public DeleteRouteRequest withClientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }

    /**
     * Configure route rule id for the request
     * @param routeRuleId the id of the route rule
     * @return DeleteRouteRequest routeRuleId
     */
    public DeleteRouteRequest withRouteRuleId(String routeRuleId) {
        this.routeRuleId = routeRuleId;
        return this;
    }
    /**
     * Configure request credential for the request.
     *
     * @param credentials a valid instance of BceCredentials.
     * @return DeleteRouteRequest with credentials.
     */
    @Override
    public DeleteRouteRequest withRequestCredentials(BceCredentials credentials) {
        return null;
    }
}
