package com.baidubce.services.subnet.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * The request for creating a newly subnet.
 */
public class CreateSubnetRequest extends AbstractBceRequest {

    /**
     * An ASCII string whose length is less than 64.
     * <p>
     * The request will be idempotent if clientToken is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/BCC/API.html#.E5.B9.82.E7.AD.89.E6.80.A7">
     * BCE API doc</a>
     */


    @JsonIgnore
    private String clientToken;

    /**
     * The name of subnet that will be created.
     */
    private String name;

    /**
     * the name of available zone which the subnet belong
     * through listZones, we can get all available zone info at current region
     * ee.g. "cn-gz-a"  "cn-gz-b"
     */
    private String zoneName;

    /**
     * The CIDR of this subnet.
     */
    private String cidr;

    /**
     * The id of vpc which this subnet belong.
     */
    private String vpcId;

    /**
     * The option param to describe the type of subnet create
     * See more detail on
     * <a href = "https://cloud.baidu.com/doc/VPC/API.html#.E5.88.9B.E5.BB.BA.E5.AD.90.E7.BD.91">
     * Subnet API doc</a>
     */
    private String subnetType;

    /***
     * whether assign Ipv6 cidr for subnet
     */
    private Boolean enableIpv6;

    /**
     * The option param to describe the subnet
     */
    private String description;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getZoneName() {
        return zoneName;
    }

    public void setZoneName(String zoneName) {
        this.zoneName = zoneName;
    }

    public String getCidr() {
        return cidr;
    }

    public void setCidr(String cidr) {
        this.cidr = cidr;
    }

    public String getVpcId() {
        return vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getSubnetType() {
        return subnetType;
    }

    public void setSubnetType(String subnetType) {
        this.subnetType = subnetType;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getClientToken() {
        return clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public Boolean getEnableIpv6() {
        return enableIpv6;
    }

    public void setEnableIpv6(Boolean enableIpv6) {
        this.enableIpv6 = enableIpv6;
    }

    /**
     * Configure optional client token for the request. The request will be idempotent if client token is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     *
     * @param clientToken An ASCII string whose length is less than 64.
     *                    See more detail at
     *                    <a href = "https://bce.baidu.com/doc/BCC/API.html#.E5.B9.82.E7.AD.89.E6.80.A7">
     *                    BCE API doc</a>
     * @return CreateSubnetRequest with specific clientToken
     */
    public CreateSubnetRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    /**
     * Configure name for the request.
     *
     * @param name The name of subnet
     * @return CreateSubnetRequest with specific name
     */
    public CreateSubnetRequest withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Configure zoneName for the request.
     *
     * @param zoneName the name of available zone
     * @return CreateSubnetRequest with zone name
     */
    public CreateSubnetRequest withZoneName(String zoneName) {
        this.zoneName = zoneName;
        return this;
    }

    /**
     * Configure cidr for the request.
     *
     * @param cidr the cidr of subnet
     * @return CreateSubnetRequest with cidr
     */
    public CreateSubnetRequest withCidr(String cidr) {
        this.cidr = cidr;
        return this;
    }

    /**
     * Configure vpc id for the request.
     *
     * @param vpcId the vpcId of subnet
     * @return CreateSubnetRequest with vpcId
     */
    public CreateSubnetRequest withVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    /**
     * Configure subnet type for the request.
     *
     * @param subnetType the type of subnet
     * @return CreateSubnetRequest with subnet type
     */
    public CreateSubnetRequest withSubnetType(String subnetType) {
        this.subnetType = subnetType;
        return this;
    }

    /**
     * Configure description for the request.
     *
     * @param description the type of subnet
     * @return CreateSubnetRequest with description
     */
    public CreateSubnetRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Configure request credential for the request.
     *
     * @param credentials a valid instance of BceCredentials.
     * @return CreateInstanceRequest with credentials.
     */
    public CreateSubnetRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
