/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.annotation;

import com.corundumstudio.socketio.annotation.AnnotationScanner;
import com.corundumstudio.socketio.annotation.OnConnectScanner;
import com.corundumstudio.socketio.annotation.OnDisconnectScanner;
import com.corundumstudio.socketio.annotation.OnEventScanner;
import com.corundumstudio.socketio.namespace.Namespace;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScannerEngine {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final List<? extends AnnotationScanner> annotations = Arrays.asList(new OnConnectScanner(), new OnDisconnectScanner(), new OnEventScanner());

    private Method findSimilarMethod(Class<?> objectClazz, Method method) {
        Method[] methods;
        for (Method m : methods = objectClazz.getDeclaredMethods()) {
            if (!this.equals(m, method)) continue;
            return m;
        }
        return null;
    }

    public void scan(Namespace namespace, Object object, Class<?> clazz) throws IllegalArgumentException {
        block7: {
            block8: {
                Method[] methods;
                block6: {
                    methods = clazz.getDeclaredMethods();
                    if (clazz.isAssignableFrom(object.getClass())) break block6;
                    for (Method method : methods) {
                        for (AnnotationScanner annotationScanner : annotations) {
                            Annotation ann = method.getAnnotation(annotationScanner.getScanAnnotation());
                            if (ann == null) continue;
                            annotationScanner.validate(method, clazz);
                            Method m = this.findSimilarMethod(object.getClass(), method);
                            if (m != null) {
                                annotationScanner.addListener(namespace, object, m, ann);
                                continue;
                            }
                            this.log.warn("Method similar to " + method.getName() + " can't be found in " + object.getClass());
                        }
                    }
                    break block7;
                }
                for (Method method : methods) {
                    for (AnnotationScanner annotationScanner : annotations) {
                        Annotation ann = method.getAnnotation(annotationScanner.getScanAnnotation());
                        if (ann == null) continue;
                        annotationScanner.validate(method, clazz);
                        this.makeAccessible(method);
                        annotationScanner.addListener(namespace, object, method, ann);
                    }
                }
                if (clazz.getSuperclass() == null) break block8;
                this.scan(namespace, object, clazz.getSuperclass());
                break block7;
            }
            if (!clazz.isInterface()) break block7;
            for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
                this.scan(namespace, object, (Class<?>)genericDeclaration);
            }
        }
    }

    private boolean equals(Method method1, Method method2) {
        if (!method1.getName().equals(method2.getName()) || !method1.getReturnType().equals(method2.getReturnType())) {
            return false;
        }
        return Arrays.equals(method1.getParameterTypes(), method2.getParameterTypes());
    }

    private void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }
}

