/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi;

import java.lang.reflect.Field;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFAbstractNum;
import org.apache.poi.xwpf.usermodel.XWPFNum;
import org.apache.poi.xwpf.usermodel.XWPFNumbering;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberingWrapper {
    private static Logger logger = LoggerFactory.getLogger(NumberingWrapper.class);
    private final XWPFNumbering numbering;
    private List<XWPFNum> nums;
    private List<XWPFAbstractNum> abstractNums;

    public NumberingWrapper(XWPFNumbering numbering) {
        this.numbering = numbering;
        this.nums = this.tryGetNums();
        this.abstractNums = this.tryGetAbstractNums();
    }

    private List<XWPFNum> tryGetNums() {
        try {
            Field field = XWPFNumbering.class.getDeclaredField("nums");
            field.setAccessible(true);
            return (List)field.get(this.numbering);
        }
        catch (Exception e) {
            logger.error("Cannot get XWPFNumbering nums", (Throwable)e);
            return null;
        }
    }

    private List<XWPFAbstractNum> tryGetAbstractNums() {
        try {
            Field field = XWPFNumbering.class.getDeclaredField("abstractNums");
            field.setAccessible(true);
            return (List)field.get(this.numbering);
        }
        catch (Exception e) {
            logger.error("Cannot get XWPFNumbering abstractNums", (Throwable)e);
            return null;
        }
    }

    public List<XWPFAbstractNum> getAbstractNums() {
        return this.abstractNums;
    }

    public List<XWPFNum> getNums() {
        return this.nums;
    }

    public XWPFNumbering getNumbering() {
        return this.numbering;
    }

    public int getAbstractNumsSize() {
        return this.abstractNums == null ? 0 : this.abstractNums.size();
    }
}

