/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.config;

import com.deepoove.poi.config.Configure;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.policy.ref.ReferenceRenderPolicy;
import com.deepoove.poi.render.compute.RenderDataComputeFactory;
import com.deepoove.poi.resolver.RunTemplateFactory;
import com.deepoove.poi.util.RegexUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigureBuilder {
    private Configure config = new Configure();

    public ConfigureBuilder buildGramer(String prefix, String suffix) {
        this.config.gramerPrefix = prefix;
        this.config.gramerSuffix = suffix;
        return this;
    }

    public ConfigureBuilder buidIterableLeft(char c) {
        this.config.iterable = Pair.of((Object)Character.valueOf(c), (Object)this.config.iterable.getRight());
        return this;
    }

    public ConfigureBuilder buildGrammerRegex(String reg) {
        this.config.grammerRegex = reg;
        return this;
    }

    public ConfigureBuilder setElMode(Configure.ELMode mode) {
        this.config.elMode = mode;
        return this;
    }

    public ConfigureBuilder setValidErrorHandler(Configure.ValidErrorHandler handler) {
        this.config.handler = handler;
        return this;
    }

    public ConfigureBuilder setRenderDataComputeFactory(RenderDataComputeFactory renderDataComputeFactory) {
        this.config.renderDataComputeFactory = renderDataComputeFactory;
        return this;
    }

    public ConfigureBuilder setRunTemplateFactory(RunTemplateFactory<?> runTemplateFactory) {
        this.config.runTemplateFactory = runTemplateFactory;
        return this;
    }

    public ConfigureBuilder addPlugin(char c, RenderPolicy policy) {
        this.config.plugin(c, policy);
        return this;
    }

    @Deprecated
    public ConfigureBuilder customPolicy(String tagName, RenderPolicy policy) {
        this.config.customPolicy(tagName, policy);
        return this;
    }

    public ConfigureBuilder referencePolicy(ReferenceRenderPolicy<?> policy) {
        this.config.referencePolicy(policy);
        return this;
    }

    public ConfigureBuilder bind(String tagName, RenderPolicy policy) {
        this.config.customPolicy(tagName, policy);
        return this;
    }

    public Configure build() {
        if (this.config.elMode == Configure.ELMode.SPEL_MODE) {
            this.config.grammerRegex = RegexUtils.createGeneral(this.config.gramerPrefix, this.config.gramerSuffix);
        }
        return this.config;
    }
}

