/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.el;

import com.deepoove.poi.el.ELObject;
import com.deepoove.poi.el.FieldFinder;
import com.deepoove.poi.el.ReadMethodFinder;
import com.deepoove.poi.exception.ExpressionEvalException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dot {
    private Logger logger = LoggerFactory.getLogger(Dot.class);
    private String el;
    private Dot target;
    private String key;
    static final Pattern EL_PATTERN = Pattern.compile("^[^\\.]+(\\.[^\\.]+)*$");

    public Dot(String el) {
        Objects.requireNonNull(el, "EL cannot be null.");
        if (!EL_PATTERN.matcher(el).matches()) {
            throw new ExpressionEvalException("Error EL fomart: " + el);
        }
        this.el = el;
        int dotIndex = el.lastIndexOf(".");
        if (-1 == dotIndex) {
            this.key = el;
        } else {
            this.key = el.substring(dotIndex + 1);
            this.target = new Dot(el.substring(0, dotIndex));
        }
    }

    public Object eval(ELObject elObject) {
        Object result;
        if (elObject.cache.containsKey(this.el)) {
            return elObject.cache.get(this.el);
        }
        Object object = result = null != this.target ? (result = this.evalKey(this.target.eval(elObject))) : this.evalKey(elObject.model);
        if (null != result) {
            elObject.cache.put(this.el, result);
        }
        return result;
    }

    private Object evalKey(Object obj) {
        Field field;
        if (null == obj) {
            throw new ExpressionEvalException("Error eval " + this.key + ", the value of " + this.target + " is null");
        }
        Class<?> objClass = obj.getClass();
        if (obj instanceof String || obj instanceof Number || obj instanceof Date || obj instanceof Collection || obj instanceof Boolean || objClass.isArray() || objClass.isPrimitive()) {
            throw new ExpressionEvalException("Error eval " + this.key + ", the type of " + this.target + "must be Hash, but is " + objClass);
        }
        if (obj instanceof Map) {
            return ((Map)obj).get(this.key);
        }
        Method readMethod = ReadMethodFinder.find(objClass, this.key);
        if (null != readMethod) {
            try {
                return readMethod.invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                this.logger.info("Introspector {} fail: {}", (Object)this.key, (Object)e.getMessage());
            }
        }
        if (null == (field = FieldFinder.find(objClass, this.key))) {
            throw new ExpressionEvalException("Cannot find property " + this.key + " from " + objClass);
        }
        try {
            return field.get(obj);
        }
        catch (Exception e) {
            throw new ExpressionEvalException("Error read the property:" + this.key + " from " + objClass);
        }
    }

    public String getEl() {
        return this.el;
    }

    public Dot getTarget() {
        return this.target;
    }

    public String getKey() {
        return this.key;
    }

    public String toString() {
        return null == this.el ? "[root el]" : this.el;
    }
}

