/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy.ref;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.policy.ref.OptionalText;
import com.deepoove.poi.policy.ref.ReferenceRenderPolicy;
import com.deepoove.poi.xwpf.NiceXWPFDocument;
import java.util.List;
import java.util.Objects;
import javax.xml.namespace.QName;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.xmlbeans.SimpleValue;
import org.apache.xmlbeans.impl.values.TypeStoreUser;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.impl.CTTblPrImpl;

public abstract class OptionalTextTableRefRenderPolicy
extends ReferenceRenderPolicy<XWPFTable>
implements OptionalText {
    protected static final QName TBLCAPTION = new QName("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "tblCaption");
    protected static final QName TBLDESCRIPTION = new QName("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "tblDescription");
    protected static final QName VAL = new QName("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "val");

    @Override
    protected XWPFTable locate(XWPFTemplate template) {
        this.logger.info("Try locate the XWPFTable object which mathing optional text [{}]...", (Object)this.optionalText());
        NiceXWPFDocument xwpfDocument = template.getXWPFDocument();
        List<XWPFTable> tables = xwpfDocument.getAllTables();
        for (XWPFTable table : tables) {
            CTTbl ctTbl = table.getCTTbl();
            CTTblPr tblPr = ctTbl.getTblPr();
            CTTblPrImpl cTTblPrImpl = (CTTblPrImpl)tblPr;
            String caption = this.getTblStringVal(cTTblPrImpl, TBLCAPTION);
            if (Objects.equals(this.optionalText(), caption)) {
                return table;
            }
            String description = this.getTblStringVal(cTTblPrImpl, TBLDESCRIPTION);
            if (!Objects.equals(this.optionalText(), description)) continue;
            return table;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTblStringVal(CTTblPrImpl cTTblPrImpl, QName qname) {
        Object object = cTTblPrImpl.monitor();
        synchronized (object) {
            if (cTTblPrImpl.get_store().count_elements(qname) == 0) {
                return null;
            }
            TypeStoreUser find_element_user = cTTblPrImpl.get_store().find_element_user(qname, 0);
            if (null == find_element_user) {
                return null;
            }
            TypeStoreUser find_attribute_user = find_element_user.get_store().find_attribute_user(VAL);
            if (null == find_attribute_user) {
                return null;
            }
            return ((SimpleValue)find_attribute_user).getStringValue();
        }
    }
}

