/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy.ref;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.policy.ref.IndexRefRenderPolicy;
import com.deepoove.poi.util.ByteUtils;
import com.deepoove.poi.xwpf.NiceXWPFDocument;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.poi.xwpf.usermodel.XWPFPicture;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlip;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlipFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture;

public class ReplaceIndexPictureRefRenderPolicy
extends IndexRefRenderPolicy<XWPFPicture> {
    private final int index;
    private byte[] data;
    private int fomart;

    public ReplaceIndexPictureRefRenderPolicy(int index, InputStream replaceStream, int fomart) {
        this(index, ByteUtils.toByteArray(replaceStream), fomart);
    }

    public ReplaceIndexPictureRefRenderPolicy(int index, byte[] replaceData, int fomart) {
        this.index = index;
        this.data = replaceData;
        this.fomart = fomart;
    }

    @Override
    public int index() {
        return this.index;
    }

    @Override
    public void doRender(XWPFPicture t, XWPFTemplate template) throws Exception {
        this.logger.info("Replace the picture data for the reference object: {}", (Object)t);
        NiceXWPFDocument doc = template.getXWPFDocument();
        try (ByteArrayInputStream ins = new ByteArrayInputStream(this.data);){
            String relationId = doc.addPictureData(ins, this.fomart);
            CTPicture ctPic = t.getCTPicture();
            CTBlipFillProperties bill = ctPic.getBlipFill();
            CTBlip blip = bill.getBlip();
            blip.setEmbed(relationId);
        }
    }
}

