/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy.reference;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.data.ChartSingleSeriesRenderData;
import com.deepoove.poi.data.SeriesRenderData;
import com.deepoove.poi.policy.reference.AbstractChartTemplateRenderPolicy;
import com.deepoove.poi.template.ChartTemplate;
import java.util.Arrays;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import org.apache.poi.xwpf.usermodel.XWPFChart;

public class SingleSeriesChartTemplateRenderPolicy
extends AbstractChartTemplateRenderPolicy<ChartSingleSeriesRenderData> {
    @Override
    public void doRender(ChartTemplate eleTemplate, ChartSingleSeriesRenderData data, XWPFTemplate template) throws Exception {
        if (null == data) {
            return;
        }
        XWPFChart chart = eleTemplate.getChart();
        XDDFChartData pie = (XDDFChartData)chart.getChartSeries().get(0);
        SeriesRenderData seriesDatas = data.getSeriesData();
        XDDFCategoryDataSource categoriesData = this.createCategoryDataSource(chart, data.getCategories());
        XDDFNumericalDataSource valuesData = this.createValueDataSource(chart, seriesDatas.getValues(), 0);
        XDDFChartData.Series currentSeries = pie.getSeries(0);
        currentSeries.replaceData((XDDFDataSource)categoriesData, valuesData);
        currentSeries.setTitle(seriesDatas.getName(), chart.setSheetTitle(seriesDatas.getName(), 1));
        this.updateCTTable(chart.getWorkbook().getSheetAt(0), Arrays.asList(seriesDatas));
        this.plot(chart, pie);
        chart.setTitleText(data.getChartTitle());
        chart.setTitleOverlay(false);
    }
}

