/*
 * Decompiled with CFR 0.152.
 */
package com.dingxianginc.ctu.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dingxianginc.ctu.client.model.CaptchaResponse;
import com.dingxianginc.ctu.client.util.HttpClientPool;
import com.dingxianginc.ctu.client.util.InputStreamUtils;
import com.dingxianginc.ctu.client.util.StringUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;

public class CaptchaClient {
    private String captchaUrl = "https://cap.dingxiang-inc.com/api/tokenVerify";
    private String appId;
    private String appSecret;
    RequestConfig requestConfig = null;
    CloseableHttpClient httpClient = null;

    public CaptchaClient(String appId, String appSecret) {
        this.appId = appId;
        this.appSecret = appSecret;
        this.httpClient = HttpClientPool.getInstance().getHttpClient();
        this.requestConfig = HttpClientPool.getInstance().getRequestConfig();
    }

    public void setCaptchaUrl(String captchaUrl) {
        this.captchaUrl = captchaUrl;
    }

    public CaptchaClient(String appId, String appSecret, int connectTimeout, int connectionRequestTimeout, int socketTimeout) {
        this.appId = appId;
        this.appSecret = appSecret;
        this.httpClient = HttpClientPool.getInstance().getHttpClient();
        this.requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectionRequestTimeout).setSocketTimeout(socketTimeout).build();
    }

    public CaptchaResponse verifyToken(String token, String ip) throws Exception {
        return this.getResponse(token, ip);
    }

    public CaptchaResponse verifyToken(String token) throws Exception {
        return this.getResponse(token, null);
    }

    private CaptchaResponse getResponse(String token, String ip) throws Exception {
        if (StringUtils.isEmpty(token) || StringUtils.isEmpty(this.appId) || StringUtils.isEmpty(this.appSecret) || token.length() > 1024 || token.length() < 10) {
            return new CaptchaResponse(false, "WRONG_PARAMETER");
        }
        String[] args = token.split(":");
        String sign = this.getVerifySign(this.appSecret, args[0]);
        String key = null;
        key = args.length == 2 ? args[1] : "";
        String reqUrl = String.format("%s?token=%s&constId=%s&appKey=%s&sign=%s&ip=%s", this.captchaUrl, args[0], key, this.appId, sign, ip == null ? "" : ip);
        return this.getHttpResponse(reqUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaptchaResponse getHttpResponse(String reqUrl) throws Exception {
        HttpGet httpGet = null;
        boolean flag = false;
        try {
            httpGet = new HttpGet(reqUrl);
            httpGet.setConfig(this.requestConfig);
        }
        catch (Exception e) {
            flag = true;
            e.printStackTrace();
        }
        if (flag || httpGet == null) {
            return new CaptchaResponse(false, "WRONG_PARAMETER");
        }
        CloseableHttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200) {
                String responseData = InputStreamUtils.readToString(response.getEntity().getContent());
                JSONObject resObject = JSON.parseObject((String)responseData);
                Boolean result = Boolean.parseBoolean(resObject.getString("success"));
                String ip = resObject.getString("ip");
                String tpc = resObject.getString("tpc");
                String uid = resObject.getString("uid");
                String code = resObject.getString("code");
                CaptchaResponse captchaResponse = new CaptchaResponse(result, "SERVER_SUCCESS", ip, tpc, uid, code);
                return captchaResponse;
            }
            CaptchaResponse responseData = new CaptchaResponse(true, "SERVER_FAILED");
            return responseData;
        }
        catch (Exception e) {
            CaptchaResponse captchaResponse = new CaptchaResponse(true, "server connect error:" + e.getMessage());
            return captchaResponse;
        }
        finally {
            if (response != null) {
                response.close();
            }
            httpGet.releaseConnection();
        }
    }

    private String getVerifySign(String appSecret, String token) {
        StringBuilder sb = new StringBuilder();
        sb.append(appSecret).append(token).append(appSecret);
        return DigestUtils.md5Hex((String)sb.toString());
    }
}

