/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class ChatHistoryApi {
    private ApiClient apiClient;

    public ChatHistoryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ChatHistoryApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call orgNameAppNameChatmessagesGetCall(String orgName, String appName, String authorization, String ql, String limit, String cursor, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameChatmessagesGet(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameChatmessagesGet(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameChatmessagesGet(Async)");
        }
        String localVarPath = "/{org_name}/{app_name}/chatmessages".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (ql != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ql", ql));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        }
        if (cursor != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "cursor", cursor));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public String orgNameAppNameChatmessagesGet(String orgName, String appName, String authorization, String ql, String limit, String cursor) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameChatmessagesGetWithHttpInfo(orgName, appName, authorization, ql, limit, cursor);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameChatmessagesGetWithHttpInfo(String orgName, String appName, String authorization, String ql, String limit, String cursor) throws ApiException {
        Call call = this.orgNameAppNameChatmessagesGetCall(orgName, appName, authorization, ql, limit, cursor, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameChatmessagesGetAsync(String orgName, String appName, String authorization, String ql, String limit, String cursor, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameChatmessagesGetCall(orgName, appName, authorization, ql, limit, cursor, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameChatmessagesTimeGetCall(String orgName, String appName, String authorization, String time, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameChatmessagesTimeGet(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameChatmessagesTimeGet(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameChatmessagesTimeGet(Async)");
        }
        if (time == null) {
            throw new ApiException("Missing the required parameter 'time' when calling orgNameAppNameChatmessagesTimeGet(Async)");
        }
        String localVarPath = "/{org_name}/{app_name}/chatmessages/{time}".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{time\\}", this.apiClient.escapeString(time.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public String orgNameAppNameChatmessagesTimeGet(String orgName, String appName, String authorization, String time) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameChatmessagesTimeGetWithHttpInfo(orgName, appName, authorization, time);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameChatmessagesTimeGetWithHttpInfo(String orgName, String appName, String authorization, String time) throws ApiException {
        Call call = this.orgNameAppNameChatmessagesTimeGetCall(orgName, appName, authorization, time, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameChatmessagesTimeGetAsync(String orgName, String appName, String authorization, String time, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameChatmessagesTimeGetCall(orgName, appName, authorization, time, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

