/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;
import io.swagger.client.model.NewPassword;
import io.swagger.client.model.Nickname;
import io.swagger.client.model.RegisterUsers;
import io.swagger.client.model.UserNames;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class UsersApi {
    private ApiClient apiClient;

    public UsersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UsersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call orgNameAppNameUsersDeleteCall(String orgName, String appName, String authorization, String limit, String cursor, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameUsersDelete(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameUsersDelete(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameUsersDelete(Async)");
        }
        if (limit == null) {
            throw new ApiException("Missing the required parameter 'limit' when calling orgNameAppNameUsersDelete(Async)");
        }
        String localVarPath = "/{org_name}/{app_name}/users".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        }
        if (cursor != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "cursor", cursor));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public String orgNameAppNameUsersDelete(String orgName, String appName, String authorization, String limit, String cursor) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameUsersDeleteWithHttpInfo(orgName, appName, authorization, limit, cursor);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameUsersDeleteWithHttpInfo(String orgName, String appName, String authorization, String limit, String cursor) throws ApiException {
        Call call = this.orgNameAppNameUsersDeleteCall(orgName, appName, authorization, limit, cursor, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameUsersDeleteAsync(String orgName, String appName, String authorization, String limit, String cursor, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameUsersDeleteCall(orgName, appName, authorization, limit, cursor, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameUsersGetCall(String orgName, String appName, String authorization, String limit, String cursor, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameUsersGet(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameUsersGet(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameUsersGet(Async)");
        }
        String localVarPath = "/{org_name}/{app_name}/users".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        }
        if (cursor != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "cursor", cursor));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public String orgNameAppNameUsersGet(String orgName, String appName, String authorization, String limit, String cursor) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameUsersGetWithHttpInfo(orgName, appName, authorization, limit, cursor);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameUsersGetWithHttpInfo(String orgName, String appName, String authorization, String limit, String cursor) throws ApiException {
        Call call = this.orgNameAppNameUsersGetCall(orgName, appName, authorization, limit, cursor, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameUsersGetAsync(String orgName, String appName, String authorization, String limit, String cursor, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameUsersGetCall(orgName, appName, authorization, limit, cursor, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameUsersOwnerUsernameBlocksUsersBlockedUsernameDeleteCall(String orgName, String appName, String authorization, String ownerUsername, String blockedUsername, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameUsersOwnerUsernameBlocksUsersBlockedUsernameDelete(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameUsersOwnerUsernameBlocksUsersBlockedUsernameDelete(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameUsersOwnerUsernameBlocksUsersBlockedUsernameDelete(Async)");
        }
        if (ownerUsername == null) {
            throw new ApiException("Missing the required parameter 'ownerUsername' when calling orgNameAppNameUsersOwnerUsernameBlocksUsersBlockedUsernameDelete(Async)");
        }
        if (blockedUsername == null) {
            throw new ApiException("Missing the required parameter 'blockedUsername' when calling orgNameAppNameUsersOwnerUsernameBlocksUsersBlockedUsernameDelete(Async)");
        }
        String localVarPath = "/{org_name}/{app_name}/users/{owner_username}/blocks/users/{blocked_username}".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{owner_username\\}", this.apiClient.escapeString(ownerUsername.toString())).replaceAll("\\{blocked_username\\}", this.apiClient.escapeString(blockedUsername.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public String orgNameAppNameUsersOwnerUsernameBlocksUsersBlockedUsernameDelete(String orgName, String appName, String authorization, String ownerUsername, String blockedUsername) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameUsersOwnerUsernameBlocksUsersBlockedUsernameDeleteWithHttpInfo(orgName, appName, authorization, ownerUsername, blockedUsername);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameUsersOwnerUsernameBlocksUsersBlockedUsernameDeleteWithHttpInfo(String orgName, String appName, String authorization, String ownerUsername, String blockedUsername) throws ApiException {
        Call call = this.orgNameAppNameUsersOwnerUsernameBlocksUsersBlockedUsernameDeleteCall(orgName, appName, authorization, ownerUsername, blockedUsername, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameUsersOwnerUsernameBlocksUsersBlockedUsernameDeleteAsync(String orgName, String appName, String authorization, String ownerUsername, String blockedUsername, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameUsersOwnerUsernameBlocksUsersBlockedUsernameDeleteCall(orgName, appName, authorization, ownerUsername, blockedUsername, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameUsersOwnerUsernameBlocksUsersGetCall(String orgName, String appName, String authorization, String ownerUsername, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameUsersOwnerUsernameBlocksUsersGet(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameUsersOwnerUsernameBlocksUsersGet(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameUsersOwnerUsernameBlocksUsersGet(Async)");
        }
        if (ownerUsername == null) {
            throw new ApiException("Missing the required parameter 'ownerUsername' when calling orgNameAppNameUsersOwnerUsernameBlocksUsersGet(Async)");
        }
        String localVarPath = "/{org_name}/{app_name}/users/{owner_username}/blocks/users".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{owner_username\\}", this.apiClient.escapeString(ownerUsername.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public String orgNameAppNameUsersOwnerUsernameBlocksUsersGet(String orgName, String appName, String authorization, String ownerUsername) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameUsersOwnerUsernameBlocksUsersGetWithHttpInfo(orgName, appName, authorization, ownerUsername);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameUsersOwnerUsernameBlocksUsersGetWithHttpInfo(String orgName, String appName, String authorization, String ownerUsername) throws ApiException {
        Call call = this.orgNameAppNameUsersOwnerUsernameBlocksUsersGetCall(orgName, appName, authorization, ownerUsername, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameUsersOwnerUsernameBlocksUsersGetAsync(String orgName, String appName, String authorization, String ownerUsername, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameUsersOwnerUsernameBlocksUsersGetCall(orgName, appName, authorization, ownerUsername, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameUsersOwnerUsernameBlocksUsersPostCall(String orgName, String appName, String authorization, String ownerUsername, UserNames usernames, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UserNames localVarPostBody = usernames;
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameUsersOwnerUsernameBlocksUsersPost(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameUsersOwnerUsernameBlocksUsersPost(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameUsersOwnerUsernameBlocksUsersPost(Async)");
        }
        if (ownerUsername == null) {
            throw new ApiException("Missing the required parameter 'ownerUsername' when calling orgNameAppNameUsersOwnerUsernameBlocksUsersPost(Async)");
        }
        if (usernames == null) {
            throw new ApiException("Missing the required parameter 'usernames' when calling orgNameAppNameUsersOwnerUsernameBlocksUsersPost(Async)");
        }
        String localVarPath = "/{org_name}/{app_name}/users/{owner_username}/blocks/users".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{owner_username\\}", this.apiClient.escapeString(ownerUsername.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public String orgNameAppNameUsersOwnerUsernameBlocksUsersPost(String orgName, String appName, String authorization, String ownerUsername, UserNames usernames) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameUsersOwnerUsernameBlocksUsersPostWithHttpInfo(orgName, appName, authorization, ownerUsername, usernames);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameUsersOwnerUsernameBlocksUsersPostWithHttpInfo(String orgName, String appName, String authorization, String ownerUsername, UserNames usernames) throws ApiException {
        Call call = this.orgNameAppNameUsersOwnerUsernameBlocksUsersPostCall(orgName, appName, authorization, ownerUsername, usernames, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameUsersOwnerUsernameBlocksUsersPostAsync(String orgName, String appName, String authorization, String ownerUsername, UserNames usernames, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameUsersOwnerUsernameBlocksUsersPostCall(orgName, appName, authorization, ownerUsername, usernames, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameUsersOwnerUsernameContactsUsersFriendUsernameDeleteCall(String orgName, String appName_, String authorization, String ownerUsername, String friendUsername, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameUsersOwnerUsernameContactsUsersFriendUsernameDelete(Async)");
        }
        if (appName_ == null) {
            throw new ApiException("Missing the required parameter 'appName_' when calling orgNameAppNameUsersOwnerUsernameContactsUsersFriendUsernameDelete(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameUsersOwnerUsernameContactsUsersFriendUsernameDelete(Async)");
        }
        if (ownerUsername == null) {
            throw new ApiException("Missing the required parameter 'ownerUsername' when calling orgNameAppNameUsersOwnerUsernameContactsUsersFriendUsernameDelete(Async)");
        }
        if (friendUsername == null) {
            throw new ApiException("Missing the required parameter 'friendUsername' when calling orgNameAppNameUsersOwnerUsernameContactsUsersFriendUsernameDelete(Async)");
        }
        String localVarPath = "/{org_name}/{app_name}/users/{owner_username}/contacts/users/{friend_username}".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name \\}", this.apiClient.escapeString(appName_.toString())).replaceAll("\\{owner_username\\}", this.apiClient.escapeString(ownerUsername.toString())).replaceAll("\\{friend_username\\}", this.apiClient.escapeString(friendUsername.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public String orgNameAppNameUsersOwnerUsernameContactsUsersFriendUsernameDelete(String orgName, String appName_, String authorization, String ownerUsername, String friendUsername) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameUsersOwnerUsernameContactsUsersFriendUsernameDeleteWithHttpInfo(orgName, appName_, authorization, ownerUsername, friendUsername);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameUsersOwnerUsernameContactsUsersFriendUsernameDeleteWithHttpInfo(String orgName, String appName_, String authorization, String ownerUsername, String friendUsername) throws ApiException {
        Call call = this.orgNameAppNameUsersOwnerUsernameContactsUsersFriendUsernameDeleteCall(orgName, appName_, authorization, ownerUsername, friendUsername, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameUsersOwnerUsernameContactsUsersFriendUsernameDeleteAsync(String orgName, String appName_, String authorization, String ownerUsername, String friendUsername, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameUsersOwnerUsernameContactsUsersFriendUsernameDeleteCall(orgName, appName_, authorization, ownerUsername, friendUsername, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameUsersOwnerUsernameContactsUsersFriendUsernamePostCall(String orgName, String appName, String authorization, String ownerUsername, String friendUsername, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameUsersOwnerUsernameContactsUsersFriendUsernamePost(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameUsersOwnerUsernameContactsUsersFriendUsernamePost(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameUsersOwnerUsernameContactsUsersFriendUsernamePost(Async)");
        }
        if (ownerUsername == null) {
            throw new ApiException("Missing the required parameter 'ownerUsername' when calling orgNameAppNameUsersOwnerUsernameContactsUsersFriendUsernamePost(Async)");
        }
        if (friendUsername == null) {
            throw new ApiException("Missing the required parameter 'friendUsername' when calling orgNameAppNameUsersOwnerUsernameContactsUsersFriendUsernamePost(Async)");
        }
        String localVarPath = "/{org_name}/{app_name}/users/{owner_username}/contacts/users/{friend_username}".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{owner_username\\}", this.apiClient.escapeString(ownerUsername.toString())).replaceAll("\\{friend_username\\}", this.apiClient.escapeString(friendUsername.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public String orgNameAppNameUsersOwnerUsernameContactsUsersFriendUsernamePost(String orgName, String appName, String authorization, String ownerUsername, String friendUsername) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameUsersOwnerUsernameContactsUsersFriendUsernamePostWithHttpInfo(orgName, appName, authorization, ownerUsername, friendUsername);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameUsersOwnerUsernameContactsUsersFriendUsernamePostWithHttpInfo(String orgName, String appName, String authorization, String ownerUsername, String friendUsername) throws ApiException {
        Call call = this.orgNameAppNameUsersOwnerUsernameContactsUsersFriendUsernamePostCall(orgName, appName, authorization, ownerUsername, friendUsername, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameUsersOwnerUsernameContactsUsersFriendUsernamePostAsync(String orgName, String appName, String authorization, String ownerUsername, String friendUsername, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameUsersOwnerUsernameContactsUsersFriendUsernamePostCall(orgName, appName, authorization, ownerUsername, friendUsername, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameUsersOwnerUsernameContactsUsersGetCall(String orgName, String appName, String authorization, String ownerUsername, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameUsersOwnerUsernameContactsUsersGet(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameUsersOwnerUsernameContactsUsersGet(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameUsersOwnerUsernameContactsUsersGet(Async)");
        }
        if (ownerUsername == null) {
            throw new ApiException("Missing the required parameter 'ownerUsername' when calling orgNameAppNameUsersOwnerUsernameContactsUsersGet(Async)");
        }
        String localVarPath = "/{org_name}/{app_name}/users/{owner_username}/contacts/users".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{owner_username\\}", this.apiClient.escapeString(ownerUsername.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public String orgNameAppNameUsersOwnerUsernameContactsUsersGet(String orgName, String appName, String authorization, String ownerUsername) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameUsersOwnerUsernameContactsUsersGetWithHttpInfo(orgName, appName, authorization, ownerUsername);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameUsersOwnerUsernameContactsUsersGetWithHttpInfo(String orgName, String appName, String authorization, String ownerUsername) throws ApiException {
        Call call = this.orgNameAppNameUsersOwnerUsernameContactsUsersGetCall(orgName, appName, authorization, ownerUsername, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameUsersOwnerUsernameContactsUsersGetAsync(String orgName, String appName, String authorization, String ownerUsername, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameUsersOwnerUsernameContactsUsersGetCall(orgName, appName, authorization, ownerUsername, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameUsersOwnerUsernameOfflineMsgCountGetCall(String orgName, String appName, String authorization, String ownerUsername, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameUsersOwnerUsernameOfflineMsgCountGet(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameUsersOwnerUsernameOfflineMsgCountGet(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameUsersOwnerUsernameOfflineMsgCountGet(Async)");
        }
        if (ownerUsername == null) {
            throw new ApiException("Missing the required parameter 'ownerUsername' when calling orgNameAppNameUsersOwnerUsernameOfflineMsgCountGet(Async)");
        }
        String localVarPath = "/{org_name}/{app_name}/users/{owner_username}/offline_msg_count".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{owner_username\\}", this.apiClient.escapeString(ownerUsername.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public String orgNameAppNameUsersOwnerUsernameOfflineMsgCountGet(String orgName, String appName, String authorization, String ownerUsername) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameUsersOwnerUsernameOfflineMsgCountGetWithHttpInfo(orgName, appName, authorization, ownerUsername);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameUsersOwnerUsernameOfflineMsgCountGetWithHttpInfo(String orgName, String appName, String authorization, String ownerUsername) throws ApiException {
        Call call = this.orgNameAppNameUsersOwnerUsernameOfflineMsgCountGetCall(orgName, appName, authorization, ownerUsername, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameUsersOwnerUsernameOfflineMsgCountGetAsync(String orgName, String appName, String authorization, String ownerUsername, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameUsersOwnerUsernameOfflineMsgCountGetCall(orgName, appName, authorization, ownerUsername, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameUsersPostCall(String orgName, String appName, RegisterUsers body, String authorization, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RegisterUsers localVarPostBody = body;
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameUsersPost(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameUsersPost(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling orgNameAppNameUsersPost(Async)");
        }
        String localVarPath = "/{org_name}/{app_name}/users".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public String orgNameAppNameUsersPost(String orgName, String appName, RegisterUsers body, String authorization) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameUsersPostWithHttpInfo(orgName, appName, body, authorization);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameUsersPostWithHttpInfo(String orgName, String appName, RegisterUsers body, String authorization) throws ApiException {
        Call call = this.orgNameAppNameUsersPostCall(orgName, appName, body, authorization, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameUsersPostAsync(String orgName, String appName, RegisterUsers body, String authorization, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameUsersPostCall(orgName, appName, body, authorization, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameUsersUsernameActivatePostCall(String orgName, String appName, String authorization, String username, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameUsersUsernameActivatePost(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameUsersUsernameActivatePost(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameUsersUsernameActivatePost(Async)");
        }
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling orgNameAppNameUsersUsernameActivatePost(Async)");
        }
        String localVarPath = "/{org_name}/{app_name}/users/{username}/activate".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{username\\}", this.apiClient.escapeString(username.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public String orgNameAppNameUsersUsernameActivatePost(String orgName, String appName, String authorization, String username) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameUsersUsernameActivatePostWithHttpInfo(orgName, appName, authorization, username);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameUsersUsernameActivatePostWithHttpInfo(String orgName, String appName, String authorization, String username) throws ApiException {
        Call call = this.orgNameAppNameUsersUsernameActivatePostCall(orgName, appName, authorization, username, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameUsersUsernameActivatePostAsync(String orgName, String appName, String authorization, String username, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameUsersUsernameActivatePostCall(orgName, appName, authorization, username, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameUsersUsernameDeactivatePostCall(String orgName, String appName, String authorization, String username, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameUsersUsernameDeactivatePost(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameUsersUsernameDeactivatePost(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameUsersUsernameDeactivatePost(Async)");
        }
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling orgNameAppNameUsersUsernameDeactivatePost(Async)");
        }
        String localVarPath = "/{org_name}/{app_name}/users/{username}/deactivate".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{username\\}", this.apiClient.escapeString(username.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public String orgNameAppNameUsersUsernameDeactivatePost(String orgName, String appName, String authorization, String username) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameUsersUsernameDeactivatePostWithHttpInfo(orgName, appName, authorization, username);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameUsersUsernameDeactivatePostWithHttpInfo(String orgName, String appName, String authorization, String username) throws ApiException {
        Call call = this.orgNameAppNameUsersUsernameDeactivatePostCall(orgName, appName, authorization, username, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameUsersUsernameDeactivatePostAsync(String orgName, String appName, String authorization, String username, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameUsersUsernameDeactivatePostCall(orgName, appName, authorization, username, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameUsersUsernameDeleteCall(String orgName, String appName, String authorization, String username, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameUsersUsernameDelete(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameUsersUsernameDelete(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameUsersUsernameDelete(Async)");
        }
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling orgNameAppNameUsersUsernameDelete(Async)");
        }
        String localVarPath = "/{org_name}/{app_name}/users/{username}".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{username\\}", this.apiClient.escapeString(username.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public String orgNameAppNameUsersUsernameDelete(String orgName, String appName, String authorization, String username) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameUsersUsernameDeleteWithHttpInfo(orgName, appName, authorization, username);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameUsersUsernameDeleteWithHttpInfo(String orgName, String appName, String authorization, String username) throws ApiException {
        Call call = this.orgNameAppNameUsersUsernameDeleteCall(orgName, appName, authorization, username, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameUsersUsernameDeleteAsync(String orgName, String appName, String authorization, String username, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameUsersUsernameDeleteCall(orgName, appName, authorization, username, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameUsersUsernameDisconnectGetCall(String orgName, String appName, String authorization, String username, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameUsersUsernameDisconnectGet(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameUsersUsernameDisconnectGet(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameUsersUsernameDisconnectGet(Async)");
        }
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling orgNameAppNameUsersUsernameDisconnectGet(Async)");
        }
        String localVarPath = "/{org_name}/{app_name}/users/{username}/disconnect".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{username\\}", this.apiClient.escapeString(username.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public String orgNameAppNameUsersUsernameDisconnectGet(String orgName, String appName, String authorization, String username) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameUsersUsernameDisconnectGetWithHttpInfo(orgName, appName, authorization, username);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameUsersUsernameDisconnectGetWithHttpInfo(String orgName, String appName, String authorization, String username) throws ApiException {
        Call call = this.orgNameAppNameUsersUsernameDisconnectGetCall(orgName, appName, authorization, username, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameUsersUsernameDisconnectGetAsync(String orgName, String appName, String authorization, String username, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameUsersUsernameDisconnectGetCall(orgName, appName, authorization, username, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameUsersUsernameGetCall(String orgName, String appName, String authorization, String username, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameUsersUsernameGet(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameUsersUsernameGet(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameUsersUsernameGet(Async)");
        }
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling orgNameAppNameUsersUsernameGet(Async)");
        }
        String localVarPath = "/{org_name}/{app_name}/users/{username}".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{username\\}", this.apiClient.escapeString(username.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public String orgNameAppNameUsersUsernameGet(String orgName, String appName, String authorization, String username) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameUsersUsernameGetWithHttpInfo(orgName, appName, authorization, username);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameUsersUsernameGetWithHttpInfo(String orgName, String appName, String authorization, String username) throws ApiException {
        Call call = this.orgNameAppNameUsersUsernameGetCall(orgName, appName, authorization, username, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameUsersUsernameGetAsync(String orgName, String appName, String authorization, String username, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameUsersUsernameGetCall(orgName, appName, authorization, username, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameUsersUsernameJoinedChatgroupsGetCall(String orgName, String appName, String authorization, String username, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameUsersUsernameJoinedChatgroupsGet(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameUsersUsernameJoinedChatgroupsGet(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameUsersUsernameJoinedChatgroupsGet(Async)");
        }
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling orgNameAppNameUsersUsernameJoinedChatgroupsGet(Async)");
        }
        String localVarPath = "/{org_name}/{app_name}/users/{username}/joined_chatgroups".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{username\\}", this.apiClient.escapeString(username.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public String orgNameAppNameUsersUsernameJoinedChatgroupsGet(String orgName, String appName, String authorization, String username) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameUsersUsernameJoinedChatgroupsGetWithHttpInfo(orgName, appName, authorization, username);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameUsersUsernameJoinedChatgroupsGetWithHttpInfo(String orgName, String appName, String authorization, String username) throws ApiException {
        Call call = this.orgNameAppNameUsersUsernameJoinedChatgroupsGetCall(orgName, appName, authorization, username, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameUsersUsernameJoinedChatgroupsGetAsync(String orgName, String appName, String authorization, String username, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameUsersUsernameJoinedChatgroupsGetCall(orgName, appName, authorization, username, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameUsersUsernameJoinedChatroomsGetCall(String orgName, String appName, String authorization, String username, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameUsersUsernameJoinedChatroomsGet(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameUsersUsernameJoinedChatroomsGet(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameUsersUsernameJoinedChatroomsGet(Async)");
        }
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling orgNameAppNameUsersUsernameJoinedChatroomsGet(Async)");
        }
        String localVarPath = "/{org_name}/{app_name}/users/{username}/joined_chatrooms".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{username\\}", this.apiClient.escapeString(username.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public String orgNameAppNameUsersUsernameJoinedChatroomsGet(String orgName, String appName, String authorization, String username) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameUsersUsernameJoinedChatroomsGetWithHttpInfo(orgName, appName, authorization, username);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameUsersUsernameJoinedChatroomsGetWithHttpInfo(String orgName, String appName, String authorization, String username) throws ApiException {
        Call call = this.orgNameAppNameUsersUsernameJoinedChatroomsGetCall(orgName, appName, authorization, username, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameUsersUsernameJoinedChatroomsGetAsync(String orgName, String appName, String authorization, String username, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameUsersUsernameJoinedChatroomsGetCall(orgName, appName, authorization, username, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameUsersUsernameOfflineMsgStatusMsgIdGetCall(String orgName, String appName, String authorization, String username, String msgId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameUsersUsernameOfflineMsgStatusMsgIdGet(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameUsersUsernameOfflineMsgStatusMsgIdGet(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameUsersUsernameOfflineMsgStatusMsgIdGet(Async)");
        }
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling orgNameAppNameUsersUsernameOfflineMsgStatusMsgIdGet(Async)");
        }
        if (msgId == null) {
            throw new ApiException("Missing the required parameter 'msgId' when calling orgNameAppNameUsersUsernameOfflineMsgStatusMsgIdGet(Async)");
        }
        String localVarPath = "/{org_name}/{app_name}/users/{username}/offline_msg_status/{msg_id}".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{username\\}", this.apiClient.escapeString(username.toString())).replaceAll("\\{msg_id\\}", this.apiClient.escapeString(msgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put(" Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public String orgNameAppNameUsersUsernameOfflineMsgStatusMsgIdGet(String orgName, String appName, String authorization, String username, String msgId) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameUsersUsernameOfflineMsgStatusMsgIdGetWithHttpInfo(orgName, appName, authorization, username, msgId);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameUsersUsernameOfflineMsgStatusMsgIdGetWithHttpInfo(String orgName, String appName, String authorization, String username, String msgId) throws ApiException {
        Call call = this.orgNameAppNameUsersUsernameOfflineMsgStatusMsgIdGetCall(orgName, appName, authorization, username, msgId, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameUsersUsernameOfflineMsgStatusMsgIdGetAsync(String orgName, String appName, String authorization, String username, String msgId, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameUsersUsernameOfflineMsgStatusMsgIdGetCall(orgName, appName, authorization, username, msgId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameUsersUsernamePasswordPutCall(String orgName, String appName, String username, NewPassword body, String authorization, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        NewPassword localVarPostBody = body;
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameUsersUsernamePasswordPut(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameUsersUsernamePasswordPut(Async)");
        }
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling orgNameAppNameUsersUsernamePasswordPut(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling orgNameAppNameUsersUsernamePasswordPut(Async)");
        }
        String localVarPath = "/{org_name}/{app_name}/users/{username}/password".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{username\\}", this.apiClient.escapeString(username.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public String orgNameAppNameUsersUsernamePasswordPut(String orgName, String appName, String username, NewPassword body, String authorization) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameUsersUsernamePasswordPutWithHttpInfo(orgName, appName, username, body, authorization);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameUsersUsernamePasswordPutWithHttpInfo(String orgName, String appName, String username, NewPassword body, String authorization) throws ApiException {
        Call call = this.orgNameAppNameUsersUsernamePasswordPutCall(orgName, appName, username, body, authorization, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameUsersUsernamePasswordPutAsync(String orgName, String appName, String username, NewPassword body, String authorization, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameUsersUsernamePasswordPutCall(orgName, appName, username, body, authorization, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameUsersUsernamePutCall(String orgName, String appName, String username, Nickname body, String authorization, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Nickname localVarPostBody = body;
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameUsersUsernamePut(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameUsersUsernamePut(Async)");
        }
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling orgNameAppNameUsersUsernamePut(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling orgNameAppNameUsersUsernamePut(Async)");
        }
        String localVarPath = "/{org_name}/{app_name}/users/{username}".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{username\\}", this.apiClient.escapeString(username.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public String orgNameAppNameUsersUsernamePut(String orgName, String appName, String username, Nickname body, String authorization) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameUsersUsernamePutWithHttpInfo(orgName, appName, username, body, authorization);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameUsersUsernamePutWithHttpInfo(String orgName, String appName, String username, Nickname body, String authorization) throws ApiException {
        Call call = this.orgNameAppNameUsersUsernamePutCall(orgName, appName, username, body, authorization, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameUsersUsernamePutAsync(String orgName, String appName, String username, Nickname body, String authorization, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameUsersUsernamePutCall(orgName, appName, username, body, authorization, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call orgNameAppNameUsersUsernameStatusGetCall(String orgName, String appName, String authorization, String username, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (orgName == null) {
            throw new ApiException("Missing the required parameter 'orgName' when calling orgNameAppNameUsersUsernameStatusGet(Async)");
        }
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling orgNameAppNameUsersUsernameStatusGet(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling orgNameAppNameUsersUsernameStatusGet(Async)");
        }
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling orgNameAppNameUsersUsernameStatusGet(Async)");
        }
        String localVarPath = "/{org_name}/{app_name}/users/{username}/status".replaceAll("\\{format\\}", "json").replaceAll("\\{org_name\\}", this.apiClient.escapeString(orgName.toString())).replaceAll("\\{app_name\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{username\\}", this.apiClient.escapeString(username.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public String orgNameAppNameUsersUsernameStatusGet(String orgName, String appName, String authorization, String username) throws ApiException {
        ApiResponse<String> resp = this.orgNameAppNameUsersUsernameStatusGetWithHttpInfo(orgName, appName, authorization, username);
        return resp.getData();
    }

    public ApiResponse<String> orgNameAppNameUsersUsernameStatusGetWithHttpInfo(String orgName, String appName, String authorization, String username) throws ApiException {
        Call call = this.orgNameAppNameUsersUsernameStatusGetCall(orgName, appName, authorization, username, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call orgNameAppNameUsersUsernameStatusGetAsync(String orgName, String appName, String authorization, String username, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.orgNameAppNameUsersUsernameStatusGetCall(orgName, appName, authorization, username, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

