/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.hibernate5;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

public class HibernateProxySerializer
extends JsonSerializer<HibernateProxy>
implements ContextualSerializer {
    protected final BeanProperty _property;
    protected final boolean _forceLazyLoading;
    protected final boolean _serializeIdentifier;
    protected final Mapping _mapping;
    protected PropertySerializerMap _dynamicSerializers;

    public HibernateProxySerializer(boolean forceLazyLoading) {
        this(forceLazyLoading, false, null, null);
    }

    public HibernateProxySerializer(boolean forceLazyLoading, boolean serializeIdentifier) {
        this(forceLazyLoading, serializeIdentifier, null, null);
    }

    public HibernateProxySerializer(boolean forceLazyLoading, boolean serializeIdentifier, Mapping mapping) {
        this(forceLazyLoading, serializeIdentifier, mapping, null);
    }

    public HibernateProxySerializer(boolean forceLazyLoading, boolean serializeIdentifier, Mapping mapping, BeanProperty property) {
        this._forceLazyLoading = forceLazyLoading;
        this._serializeIdentifier = serializeIdentifier;
        this._mapping = mapping;
        this._dynamicSerializers = PropertySerializerMap.emptyForProperties();
        this._property = property;
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) {
        return new HibernateProxySerializer(this._forceLazyLoading, this._serializeIdentifier, this._mapping, property);
    }

    public boolean isEmpty(SerializerProvider provider, HibernateProxy value) {
        return value == null || this.findProxied(value) == null;
    }

    public void serialize(HibernateProxy value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        Object proxiedValue = this.findProxied(value);
        if (proxiedValue == null) {
            provider.defaultSerializeNull(jgen);
            return;
        }
        this.findSerializer(provider, proxiedValue).serialize(proxiedValue, jgen, provider);
    }

    public void serializeWithType(HibernateProxy value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        Object proxiedValue = this.findProxied(value);
        if (proxiedValue == null) {
            provider.defaultSerializeNull(jgen);
            return;
        }
        this.findSerializer(provider, proxiedValue).serializeWithType(proxiedValue, jgen, provider, typeSer);
    }

    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        SerializerProvider prov = visitor.getProvider();
        if (prov == null || this._property == null) {
            super.acceptJsonFormatVisitor(visitor, typeHint);
        } else {
            JavaType type = this._property.getType();
            prov.findPrimaryPropertySerializer(type, this._property).acceptJsonFormatVisitor(visitor, type);
        }
    }

    protected JsonSerializer<Object> findSerializer(SerializerProvider provider, Object value) throws IOException {
        Class<?> type = value.getClass();
        PropertySerializerMap.SerializerAndMapResult result = this._dynamicSerializers.findAndAddPrimarySerializer(type, provider, this._property);
        if (this._dynamicSerializers != result.map) {
            this._dynamicSerializers = result.map;
        }
        return result.serializer;
    }

    protected Object findProxied(HibernateProxy proxy) {
        LazyInitializer init = proxy.getHibernateLazyInitializer();
        if (!this._forceLazyLoading && init.isUninitialized()) {
            if (this._serializeIdentifier) {
                SessionImplementor session;
                String idName = this._mapping != null ? this._mapping.getIdentifierPropertyName(init.getEntityName()) : ((session = init.getSession()) != null ? session.getFactory().getIdentifierPropertyName(init.getEntityName()) : init.getEntityName());
                Serializable idValue = init.getIdentifier();
                HashMap<String, Serializable> map = new HashMap<String, Serializable>();
                map.put(idName, idValue);
                return map;
            }
            return null;
        }
        return init.getImplementation();
    }
}

