/*
 * Decompiled with CFR 0.152.
 */
package monad.mmseg;

import java.util.ArrayList;
import java.util.List;
import monad.mmseg.CharNode;
import monad.mmseg.Chunk;
import monad.mmseg.Dictionary;
import monad.mmseg.Sentence;

public abstract class Seg {
    protected Dictionary dic;

    public Seg(Dictionary dic) {
        this.dic = dic;
    }

    protected void printChunk(List<Chunk> chunks) {
        for (Chunk ck : chunks) {
            System.out.println(ck + " -> " + ck.toFactorString());
        }
    }

    protected boolean isUnit(int codePoint) {
        return this.dic.isUnit(Character.valueOf((char)codePoint));
    }

    protected int search(char[] chs, int offset, int tailLen) {
        if (tailLen == 0) {
            return -1;
        }
        CharNode cn = this.dic.head(chs[offset]);
        return this.search(cn, chs, offset, tailLen);
    }

    protected int search(CharNode cn, char[] chs, int offset, int tailLen) {
        if (tailLen == 0 || cn == null) {
            return -1;
        }
        return this.dic.search(cn, chs, offset, tailLen);
    }

    protected int maxMatch(CharNode[] cns, int cnIdx, char[] chs, int offset) {
        CharNode cn = null;
        if (offset < chs.length) {
            cn = this.dic.head(chs[offset]);
        }
        cns[cnIdx] = cn;
        return this.dic.maxMatch(cn, chs, offset);
    }

    protected void maxMatch(CharNode[] cns, int cnIdx, char[] chs, int offset, ArrayList<Integer>[] tailLens, int tailLensIdx) {
        CharNode cn = null;
        if (offset < chs.length) {
            cn = this.dic.head(chs[offset]);
        }
        cns[cnIdx] = cn;
        this.dic.maxMatch(cn, tailLens[tailLensIdx], chs, offset);
    }

    public abstract Chunk seg(Sentence var1);
}

