/*
 * Decompiled with CFR 0.152.
 */
package monad.mmseg.example;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import monad.mmseg.ComplexSeg;
import monad.mmseg.Dictionary;
import monad.mmseg.MMSeg;
import monad.mmseg.Seg;
import monad.mmseg.Word;

public class Complex {
    protected Dictionary dic = Dictionary.getInstance();

    public static void main(String[] args) throws IOException {
        new Complex().run(args);
    }

    protected Seg getSeg() {
        return new ComplexSeg(this.dic);
    }

    public String segWords(Reader input, String wordSpilt) throws IOException {
        StringBuilder sb = new StringBuilder();
        Seg seg = this.getSeg();
        MMSeg mmSeg = new MMSeg(input, seg);
        Word word = null;
        boolean first = true;
        while ((word = mmSeg.next()) != null) {
            if (!first) {
                sb.append(wordSpilt);
            }
            String w = word.getString();
            sb.append(w);
            first = false;
        }
        return sb.toString();
    }

    public String segWords(String txt, String wordSpilt) throws IOException {
        return this.segWords(new StringReader(txt), wordSpilt);
    }

    private void printlnHelp() {
        System.out.println("\n\t-- \u8bf4\u660e: \u8f93\u5165 QUIT \u6216 EXIT \u9000\u51fa");
        System.out.print("\nmmseg4j-" + this.getClass().getSimpleName().toLowerCase() + ">");
    }

    protected void run(String[] args) throws IOException {
        String txt = "\u4eac\u534e\u65f6\u62a5\uff12\uff10\uff10\uff18\u5e741\u670823\u65e5\u62a5\u9053 \u6628\u5929\uff0c\u53d7\u4e00\u80a1\u6765\u81ea\u4e2d\u897f\u4f2f\u5229\u4e9a\u7684\u5f3a\u51b7\u7a7a\u6c14\u5f71\u54cd\uff0c\u672c\u5e02\u51fa\u73b0\u5927\u98ce\u964d\u6e29\u5929\u6c14\uff0c\u767d\u5929\u6700\u9ad8\u6c14\u6e29\u53ea\u6709\u96f6\u4e0b7\u6444\u6c0f\u5ea6\uff0c\u540c\u65f6\u4f34\u67096\u52307\u7ea7\u7684\u504f\u5317\u98ce\u3002";
        if (args.length > 0) {
            txt = args[0];
        }
        System.out.println(this.segWords(txt, " | "));
        this.printlnHelp();
        String inputStr = null;
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        while ((inputStr = br.readLine()) != null) {
            if (inputStr.equals("QUIT") || inputStr.equals("EXIT")) {
                System.exit(0);
                continue;
            }
            if ("".equals(inputStr)) {
                this.printlnHelp();
                continue;
            }
            System.out.println(this.segWords(inputStr, " | "));
            System.out.print("\nmmseg4j-" + this.getClass().getSimpleName().toLowerCase() + ">");
        }
    }
}

