/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client;

import com.github.dockerjava.client.DockerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Properties;

class Config {
    URI url;
    String version;
    String username;
    String password;
    String email;

    private Config() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Config createConfig() throws DockerException {
        Properties p = new Properties();
        try {
            p.load(Config.class.getResourceAsStream("/docker.io.properties"));
        }
        catch (IOException e) {
            throw new DockerException(e);
        }
        File file = new File(System.getProperty("user.home"), ".docker.io.properties");
        if (file.isFile()) {
            try {
                FileInputStream in = new FileInputStream(file);
                try {
                    p.load(in);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException e) {
                throw new DockerException(e);
            }
        }
        for (String s : new String[]{"url", "version", "username", "password", "email"}) {
            String key = "docker.io." + s;
            if (!System.getProperties().keySet().contains(key)) continue;
            p.setProperty(key, System.getProperty(key));
        }
        Config c = new Config();
        c.url = URI.create(p.getProperty("docker.io.url"));
        c.version = p.getProperty("docker.io.version");
        c.username = p.getProperty("docker.io.username");
        c.password = p.getProperty("docker.io.password");
        c.email = p.getProperty("docker.io.email");
        return c;
    }
}

