/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client;

import com.github.dockerjava.client.Config;
import com.github.dockerjava.client.DockerException;
import com.github.dockerjava.client.command.AbstrDockerCmd;
import com.github.dockerjava.client.command.AttachContainerCmd;
import com.github.dockerjava.client.command.AuthCmd;
import com.github.dockerjava.client.command.BuildImgCmd;
import com.github.dockerjava.client.command.CommitCmd;
import com.github.dockerjava.client.command.ContainerDiffCmd;
import com.github.dockerjava.client.command.CopyFileFromContainerCmd;
import com.github.dockerjava.client.command.CreateContainerCmd;
import com.github.dockerjava.client.command.ImportImageCmd;
import com.github.dockerjava.client.command.InfoCmd;
import com.github.dockerjava.client.command.InspectContainerCmd;
import com.github.dockerjava.client.command.InspectImageCmd;
import com.github.dockerjava.client.command.KillContainerCmd;
import com.github.dockerjava.client.command.ListContainersCmd;
import com.github.dockerjava.client.command.ListImagesCmd;
import com.github.dockerjava.client.command.LogContainerCmd;
import com.github.dockerjava.client.command.PullImageCmd;
import com.github.dockerjava.client.command.PushImageCmd;
import com.github.dockerjava.client.command.RemoveContainerCmd;
import com.github.dockerjava.client.command.RemoveImageCmd;
import com.github.dockerjava.client.command.RestartContainerCmd;
import com.github.dockerjava.client.command.SearchImagesCmd;
import com.github.dockerjava.client.command.StartContainerCmd;
import com.github.dockerjava.client.command.StopContainerCmd;
import com.github.dockerjava.client.command.TagImageCmd;
import com.github.dockerjava.client.command.TopContainerCmd;
import com.github.dockerjava.client.command.VersionCmd;
import com.github.dockerjava.client.command.WaitContainerCmd;
import com.github.dockerjava.client.model.AuthConfig;
import com.github.dockerjava.client.model.CreateContainerConfig;
import com.github.dockerjava.client.utils.JsonClientFilter;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import com.sun.jersey.client.apache4.ApacheHttpClient4Handler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;

public class DockerClient {
    private Client client;
    private WebResource baseResource;
    private AuthConfig authConfig;

    public DockerClient() throws DockerException {
        this(Config.createConfig());
    }

    public DockerClient(String serverUrl) throws DockerException {
        this(DockerClient.configWithServerUrl(serverUrl));
    }

    private static Config configWithServerUrl(String serverUrl) throws DockerException {
        Config c = Config.createConfig();
        c.url = URI.create(serverUrl);
        return c;
    }

    private DockerClient(Config config) {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", config.url.getPort(), (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory()));
        PoolingClientConnectionManager cm = new PoolingClientConnectionManager(schemeRegistry);
        cm.setMaxTotal(1000);
        cm.setDefaultMaxPerRoute(1000);
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)cm);
        this.client = new ApacheHttpClient4(new ApacheHttpClient4Handler((HttpClient)httpClient, null, false), (ClientConfig)clientConfig);
        this.client.setReadTimeout(Integer.valueOf(10000));
        this.client.addFilter((ClientFilter)new JsonClientFilter());
        this.client.addFilter((ClientFilter)new LoggingFilter());
        this.baseResource = this.client.resource(config.url + "/v" + config.version);
    }

    public void setCredentials(String username, String password, String email) {
        if (username == null) {
            throw new IllegalArgumentException("username is null");
        }
        if (password == null) {
            throw new IllegalArgumentException("password is null");
        }
        if (email == null) {
            throw new IllegalArgumentException("email is null");
        }
        this.authConfig = new AuthConfig();
        this.authConfig.setUsername(username);
        this.authConfig.setPassword(password);
        this.authConfig.setEmail(email);
    }

    public <RES_T> RES_T execute(AbstrDockerCmd<?, RES_T> command) throws DockerException {
        return ((AbstrDockerCmd)command.withBaseResource(this.baseResource)).exec();
    }

    public AuthConfig authConfig() throws DockerException {
        return this.authConfig != null ? this.authConfig : DockerClient.authConfigFromProperties();
    }

    private static AuthConfig authConfigFromProperties() throws DockerException {
        AuthConfig a = new AuthConfig();
        a.setUsername(Config.createConfig().username);
        a.setPassword(Config.createConfig().password);
        a.setEmail(Config.createConfig().email);
        if (a.getUsername() == null) {
            throw new IllegalStateException("username is null");
        }
        if (a.getPassword() == null) {
            throw new IllegalStateException("password is null");
        }
        if (a.getEmail() == null) {
            throw new IllegalStateException("email is null");
        }
        return a;
    }

    public AuthCmd authCmd() {
        return (AuthCmd)new AuthCmd(this.authConfig()).withBaseResource(this.baseResource);
    }

    public InfoCmd infoCmd() throws DockerException {
        return (InfoCmd)new InfoCmd().withBaseResource(this.baseResource);
    }

    public VersionCmd versionCmd() throws DockerException {
        return (VersionCmd)new VersionCmd().withBaseResource(this.baseResource);
    }

    public PullImageCmd pullImageCmd(String repository) {
        return (PullImageCmd)new PullImageCmd(repository).withBaseResource(this.baseResource);
    }

    public PushImageCmd pushImageCmd(String name) {
        return (PushImageCmd)((PushImageCmd)new PushImageCmd(name).withAuthConfig(this.authConfig())).withBaseResource(this.baseResource);
    }

    public ImportImageCmd importImageCmd(String repository, InputStream imageStream) {
        return (ImportImageCmd)new ImportImageCmd(repository, imageStream).withBaseResource(this.baseResource);
    }

    public SearchImagesCmd searchImagesCmd(String term) {
        return (SearchImagesCmd)new SearchImagesCmd(term).withBaseResource(this.baseResource);
    }

    public RemoveImageCmd removeImageCmd(String imageId) {
        return (RemoveImageCmd)new RemoveImageCmd(imageId).withBaseResource(this.baseResource);
    }

    public ListImagesCmd listImagesCmd() {
        return (ListImagesCmd)new ListImagesCmd().withBaseResource(this.baseResource);
    }

    public InspectImageCmd inspectImageCmd(String imageId) {
        return (InspectImageCmd)new InspectImageCmd(imageId).withBaseResource(this.baseResource);
    }

    public ListContainersCmd listContainersCmd() {
        return (ListContainersCmd)new ListContainersCmd().withBaseResource(this.baseResource);
    }

    public CreateContainerCmd createContainerCmd(String image) {
        return (CreateContainerCmd)new CreateContainerCmd(new CreateContainerConfig()).withImage(image).withBaseResource(this.baseResource);
    }

    public StartContainerCmd startContainerCmd(String containerId) {
        return (StartContainerCmd)new StartContainerCmd(containerId).withBaseResource(this.baseResource);
    }

    public InspectContainerCmd inspectContainerCmd(String containerId) {
        return (InspectContainerCmd)new InspectContainerCmd(containerId).withBaseResource(this.baseResource);
    }

    public RemoveContainerCmd removeContainerCmd(String containerId) {
        return (RemoveContainerCmd)new RemoveContainerCmd(containerId).withBaseResource(this.baseResource);
    }

    public WaitContainerCmd waitContainerCmd(String containerId) {
        return (WaitContainerCmd)new WaitContainerCmd(containerId).withBaseResource(this.baseResource);
    }

    public AttachContainerCmd attachContainerCmd(String containerId) {
        return (AttachContainerCmd)new AttachContainerCmd(containerId).withBaseResource(this.baseResource);
    }

    public LogContainerCmd logContainerCmd(String containerId) {
        return (LogContainerCmd)new LogContainerCmd(containerId).withBaseResource(this.baseResource);
    }

    public CopyFileFromContainerCmd copyFileFromContainerCmd(String containerId, String resource) {
        return (CopyFileFromContainerCmd)new CopyFileFromContainerCmd(containerId, resource).withBaseResource(this.baseResource);
    }

    public ContainerDiffCmd containerDiffCmd(String containerId) {
        return (ContainerDiffCmd)new ContainerDiffCmd(containerId).withBaseResource(this.baseResource);
    }

    public StopContainerCmd stopContainerCmd(String containerId) {
        return (StopContainerCmd)new StopContainerCmd(containerId).withBaseResource(this.baseResource);
    }

    public KillContainerCmd killContainerCmd(String containerId) {
        return (KillContainerCmd)new KillContainerCmd(containerId).withBaseResource(this.baseResource);
    }

    public RestartContainerCmd restartContainerCmd(String containerId) {
        return (RestartContainerCmd)new RestartContainerCmd(containerId).withBaseResource(this.baseResource);
    }

    public CommitCmd commitCmd(String containerId) {
        return (CommitCmd)new CommitCmd(containerId).withBaseResource(this.baseResource);
    }

    public BuildImgCmd buildImageCmd(File dockerFolder) {
        return (BuildImgCmd)new BuildImgCmd(dockerFolder).withBaseResource(this.baseResource);
    }

    public BuildImgCmd buildImageCmd(InputStream tarInputStream) {
        return (BuildImgCmd)new BuildImgCmd(tarInputStream).withBaseResource(this.baseResource);
    }

    public TopContainerCmd topContainerCmd(String containerId) {
        return (TopContainerCmd)new TopContainerCmd(containerId).withBaseResource(this.baseResource);
    }

    public TagImageCmd tagImageCmd(String imageId, String repository, String tag) {
        return (TagImageCmd)new TagImageCmd(imageId, repository, tag).withBaseResource(this.baseResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String asString(ClientResponse response) throws IOException {
        StringWriter out = new StringWriter();
        try {
            LineIterator itr = IOUtils.lineIterator((InputStream)response.getEntityInputStream(), (String)"UTF-8");
            while (itr.hasNext()) {
                String line = itr.next();
                out.write(line + (itr.hasNext() ? "\n" : ""));
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)response.getEntityInputStream());
        }
        return out.toString();
    }
}

