/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client.command;

import com.github.dockerjava.client.DockerException;
import com.github.dockerjava.client.NotFoundException;
import com.github.dockerjava.client.command.AbstrDockerCmd;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachContainerCmd
extends AbstrDockerCmd<AttachContainerCmd, ClientResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachContainerCmd.class);
    private String containerId;
    private boolean logs;
    private boolean followStream;
    private boolean timestamps;
    private boolean stdout;
    private boolean stderr;

    public AttachContainerCmd(String containerId) {
        this.withContainerId(containerId);
    }

    public AttachContainerCmd withContainerId(String containerId) {
        Preconditions.checkNotNull((Object)containerId, (Object)"containerId was not specified");
        this.containerId = containerId;
        return this;
    }

    public AttachContainerCmd withFollowStream() {
        return this.withFollowStream(true);
    }

    public AttachContainerCmd withFollowStream(boolean followStream) {
        this.followStream = followStream;
        return this;
    }

    public AttachContainerCmd withTimestamps(boolean timestamps) {
        this.timestamps = timestamps;
        return this;
    }

    public AttachContainerCmd withStdOut() {
        return this.withStdOut(true);
    }

    public AttachContainerCmd withStdOut(boolean stdout) {
        this.stdout = stdout;
        return this;
    }

    public AttachContainerCmd withStdErr() {
        return this.withStdErr(true);
    }

    public AttachContainerCmd withStdErr(boolean stderr) {
        this.stderr = stderr;
        return this;
    }

    public AttachContainerCmd withLogs(boolean logs) {
        this.logs = logs;
        return this;
    }

    @Override
    protected ClientResponse impl() throws DockerException {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"logs", (Object)(this.logs ? "1" : "0"));
        params.add((Object)"timestamps", (Object)(this.timestamps ? "1" : "0"));
        params.add((Object)"stdout", (Object)(this.stdout ? "1" : "0"));
        params.add((Object)"stderr", (Object)(this.stderr ? "1" : "0"));
        params.add((Object)"follow", (Object)(this.followStream ? "1" : "0"));
        WebResource webResource = this.baseResource.path(String.format("/containers/%s/attach", this.containerId)).queryParams((MultivaluedMap)params);
        try {
            LOGGER.trace("POST: {}", (Object)webResource);
            return (ClientResponse)webResource.accept(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}).post(ClientResponse.class, (Object)params);
        }
        catch (UniformInterfaceException exception) {
            if (exception.getResponse().getStatus() == 400) {
                throw new DockerException("bad parameter");
            }
            if (exception.getResponse().getStatus() == 404) {
                throw new NotFoundException(String.format("No such container %s", this.containerId));
            }
            if (exception.getResponse().getStatus() == 500) {
                throw new DockerException("Server error", exception);
            }
            throw new DockerException(exception);
        }
    }
}

