/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client.command;

import com.github.dockerjava.client.DockerException;
import com.github.dockerjava.client.command.AbstrDockerCmd;
import com.github.dockerjava.client.utils.CompressArchiveUtil;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildImgCmd
extends AbstrDockerCmd<BuildImgCmd, ClientResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildImgCmd.class);
    private static final Pattern ADD_PATTERN = Pattern.compile("^ADD\\s+(.*)\\s+(.*)$");
    private File dockerFolder = null;
    private InputStream tarInputStream = null;
    private String tag;
    private boolean noCache;

    public BuildImgCmd(File dockerFolder) {
        Preconditions.checkNotNull((Object)dockerFolder, (Object)"dockerFolder is null");
        this.dockerFolder = dockerFolder;
    }

    public BuildImgCmd(InputStream tarInputStream) {
        Preconditions.checkNotNull((Object)tarInputStream, (Object)"tarInputStream is null");
        this.tarInputStream = tarInputStream;
    }

    public BuildImgCmd withTag(String tag) {
        Preconditions.checkNotNull((Object)tag, (Object)"Tag is null");
        this.tag = tag;
        return this;
    }

    public BuildImgCmd withNoCache(boolean noCache) {
        this.noCache = noCache;
        return this;
    }

    @Override
    protected ClientResponse impl() {
        if (this.tarInputStream == null) {
            File dockerFolderTar = this.buildDockerFolderTar();
            try {
                ClientResponse clientResponse = this.callDocker(FileUtils.openInputStream((File)dockerFolderTar));
                return clientResponse;
            }
            catch (IOException e) {
                throw new DockerException(e);
            }
            finally {
                FileUtils.deleteQuietly((File)dockerFolderTar);
            }
        }
        return this.callDocker(this.tarInputStream);
    }

    protected ClientResponse callDocker(InputStream dockerFolderTarInputStream) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"t", (Object)this.tag);
        if (this.noCache) {
            params.add((Object)"nocache", (Object)"true");
        }
        WebResource webResource = this.baseResource.path("/build").queryParams((MultivaluedMap)params);
        try {
            LOGGER.trace("POST: {}", (Object)webResource);
            return (ClientResponse)((WebResource.Builder)webResource.type("application/tar").accept(new String[]{"text/plain"})).post(ClientResponse.class, (Object)dockerFolderTarInputStream);
        }
        catch (UniformInterfaceException exception) {
            if (exception.getResponse().getStatus() == 500) {
                throw new DockerException("Server error", exception);
            }
            throw new DockerException(exception);
        }
    }

    protected File buildDockerFolderTar() {
        Preconditions.checkArgument((boolean)this.dockerFolder.exists(), (String)"Path %s doesn't exist", (Object[])new Object[]{this.dockerFolder});
        Preconditions.checkArgument((boolean)this.dockerFolder.isDirectory(), (String)"Folder %s doesn't exist", (Object[])new Object[]{this.dockerFolder});
        Preconditions.checkState((boolean)new File(this.dockerFolder, "Dockerfile").exists(), (Object)("Dockerfile doesn't exist in " + this.dockerFolder));
        String archiveNameWithOutExtension = UUID.randomUUID().toString();
        File dockerFolderTar = null;
        try {
            File dockerFile = new File(this.dockerFolder, "Dockerfile");
            List dockerFileContent = FileUtils.readLines((File)dockerFile);
            if (dockerFileContent.size() <= 0) {
                throw new DockerException(String.format("Dockerfile %s is empty", dockerFile));
            }
            ArrayList<File> filesToAdd = new ArrayList<File>();
            filesToAdd.add(dockerFile);
            for (String cmd : dockerFileContent) {
                Matcher matcher = ADD_PATTERN.matcher(cmd.trim());
                if (!matcher.find()) continue;
                if (matcher.groupCount() != 2) {
                    throw new DockerException(String.format("Wrong format on line [%s]", cmd));
                }
                String resource = matcher.group(1);
                if (!BuildImgCmd.isFileResource(resource)) continue;
                File src = new File(resource);
                if (src.isAbsolute()) {
                    throw new DockerException(String.format("Source file %s must be relative to %s", src, this.dockerFolder));
                }
                src = new File(this.dockerFolder, resource).getCanonicalFile();
                if (!src.exists()) {
                    throw new DockerException(String.format("Source file %s doesn't exist", src));
                }
                if (src.isDirectory()) {
                    filesToAdd.addAll(FileUtils.listFiles((File)src, null, (boolean)true));
                    continue;
                }
                filesToAdd.add(src);
            }
            dockerFolderTar = CompressArchiveUtil.archiveTARFiles(this.dockerFolder, filesToAdd, archiveNameWithOutExtension);
            return dockerFolderTar;
        }
        catch (IOException ex) {
            FileUtils.deleteQuietly(dockerFolderTar);
            throw new DockerException("Error occurred while preparing Docker context folder.", ex);
        }
    }

    private static boolean isFileResource(String resource) {
        URI uri;
        try {
            uri = new URI(resource);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return uri.getScheme() == null || "file".equals(uri.getScheme());
    }
}

