/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client.command;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.dockerjava.client.DockerException;
import com.github.dockerjava.client.NotFoundException;
import com.github.dockerjava.client.command.AbstrDockerCmd;
import com.github.dockerjava.client.model.CommitConfig;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import javax.ws.rs.core.MultivaluedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitCmd
extends AbstrDockerCmd<CommitCmd, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommitCmd.class);
    private CommitConfig commitConfig;

    public CommitCmd(String containerId) {
        Preconditions.checkNotNull((Object)containerId, (Object)"containerId was not specified");
        this.commitConfig = new CommitConfig(containerId);
    }

    public CommitCmd withCommitConfig(CommitConfig commitConfig) {
        this.checkCommitConfig(commitConfig);
        this.commitConfig = commitConfig;
        return this;
    }

    public CommitCmd withRepo(String repo) {
        Preconditions.checkNotNull((Object)repo, (Object)"repo was not specified");
        this.commitConfig.setRepo(repo);
        return this;
    }

    public CommitCmd withTag(String tag) {
        Preconditions.checkNotNull((Object)tag, (Object)"tag was not specified");
        this.commitConfig.setTag(tag);
        return this;
    }

    public CommitCmd withMessage(String message) {
        Preconditions.checkNotNull((Object)message, (Object)"message was not specified");
        this.commitConfig.setMessage(message);
        return this;
    }

    public CommitCmd withAuthor(String author) {
        Preconditions.checkNotNull((Object)author, (Object)"author was not specified");
        this.commitConfig.setAuthor(author);
        return this;
    }

    public CommitCmd withRun(String run) {
        Preconditions.checkNotNull((Object)run, (Object)"run was not specified");
        this.commitConfig.setRun(run);
        return this;
    }

    private void checkCommitConfig(CommitConfig commitConfig) {
        Preconditions.checkNotNull((Object)commitConfig, (Object)"CommitConfig was not specified");
    }

    @Override
    protected String impl() throws DockerException {
        this.checkCommitConfig(this.commitConfig);
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"container", (Object)this.commitConfig.getContainerId());
        params.add((Object)"repo", (Object)this.commitConfig.getRepo());
        params.add((Object)"tag", (Object)this.commitConfig.getTag());
        params.add((Object)"m", (Object)this.commitConfig.getMessage());
        params.add((Object)"author", (Object)this.commitConfig.getAuthor());
        params.add((Object)"run", (Object)this.commitConfig.getRun());
        WebResource webResource = this.baseResource.path("/commit").queryParams((MultivaluedMap)params);
        try {
            LOGGER.trace("POST: {}", (Object)webResource);
            ObjectNode ObjectNode2 = (ObjectNode)webResource.accept(new String[]{"application/vnd.docker.raw-stream"}).post(ObjectNode.class, (Object)params);
            return ObjectNode2.get("Id").asText();
        }
        catch (UniformInterfaceException exception) {
            if (exception.getResponse().getStatus() == 404) {
                throw new NotFoundException(String.format("No such container %s", this.commitConfig.getContainerId()));
            }
            if (exception.getResponse().getStatus() == 500) {
                throw new DockerException("Server error", exception);
            }
            throw new DockerException(exception);
        }
        catch (Exception e) {
            throw new DockerException(e);
        }
    }
}

