/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client.command;

import com.github.dockerjava.client.DockerException;
import com.github.dockerjava.client.NotFoundException;
import com.github.dockerjava.client.command.AbstrDockerCmd;
import com.github.dockerjava.client.model.ChangeLog;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerDiffCmd
extends AbstrDockerCmd<ContainerDiffCmd, List<ChangeLog>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainerDiffCmd.class);
    private String containerId;

    public ContainerDiffCmd(String containerId) {
        this.withContainerId(containerId);
    }

    public ContainerDiffCmd withContainerId(String containerId) {
        Preconditions.checkNotNull((Object)containerId, (Object)"containerId was not specified");
        this.containerId = containerId;
        return this;
    }

    @Override
    protected List<ChangeLog> impl() throws DockerException {
        WebResource webResource = this.baseResource.path(String.format("/containers/%s/changes", this.containerId));
        try {
            LOGGER.trace("GET: {}", (Object)webResource);
            return (List)webResource.accept(new String[]{"application/json"}).get((GenericType)new GenericType<List<ChangeLog>>(){});
        }
        catch (UniformInterfaceException exception) {
            if (exception.getResponse().getStatus() == 404) {
                throw new NotFoundException(String.format("No such container %s", this.containerId));
            }
            if (exception.getResponse().getStatus() == 500) {
                throw new DockerException("Server error", exception);
            }
            throw new DockerException(exception);
        }
    }
}

