/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client.command;

import com.github.dockerjava.client.DockerException;
import com.github.dockerjava.client.command.AbstrDockerCmd;
import com.github.dockerjava.client.model.CopyConfig;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import javax.ws.rs.core.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyFileFromContainerCmd
extends AbstrDockerCmd<CopyFileFromContainerCmd, ClientResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CopyFileFromContainerCmd.class);
    private String containerId;
    private String resource;

    public CopyFileFromContainerCmd(String containerId, String resource) {
        this.withContainerId(containerId);
        this.withResource(resource);
    }

    public CopyFileFromContainerCmd withContainerId(String containerId) {
        Preconditions.checkNotNull((Object)containerId, (Object)"containerId was not specified");
        this.containerId = containerId;
        return this;
    }

    public CopyFileFromContainerCmd withResource(String resource) {
        Preconditions.checkNotNull((Object)resource, (Object)"resource was not specified");
        this.resource = resource;
        return this;
    }

    @Override
    protected ClientResponse impl() throws DockerException {
        CopyConfig copyConfig = new CopyConfig();
        copyConfig.setResource(this.resource);
        WebResource webResource = this.baseResource.path(String.format("/containers/%s/copy", this.containerId));
        try {
            LOGGER.trace("POST: " + webResource.toString());
            WebResource.Builder builder = (WebResource.Builder)webResource.accept(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}).type("application/json");
            return (ClientResponse)builder.post(ClientResponse.class, (Object)copyConfig.toString());
        }
        catch (UniformInterfaceException exception) {
            if (exception.getResponse().getStatus() == 400) {
                throw new DockerException("bad parameter");
            }
            if (exception.getResponse().getStatus() == 404) {
                throw new DockerException(String.format("No such container %s", this.containerId));
            }
            if (exception.getResponse().getStatus() == 500) {
                throw new DockerException("Server error", exception);
            }
            throw new DockerException(exception);
        }
    }
}

