/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client.command;

import com.github.dockerjava.client.DockerException;
import com.github.dockerjava.client.NotFoundException;
import com.github.dockerjava.client.command.AbstrDockerCmd;
import com.github.dockerjava.client.model.ContainerCreateResponse;
import com.github.dockerjava.client.model.CreateContainerConfig;
import com.github.dockerjava.client.model.ExposedPort;
import com.github.dockerjava.client.model.Volume;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import javax.ws.rs.core.MultivaluedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateContainerCmd
extends AbstrDockerCmd<CreateContainerCmd, ContainerCreateResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateContainerCmd.class);
    private CreateContainerConfig containerCreateConfig;
    private String name;

    public CreateContainerCmd(String image) {
        this(new CreateContainerConfig());
        Preconditions.checkNotNull((Object)image, (Object)"image was not specified");
        this.containerCreateConfig.withImage(image);
    }

    public CreateContainerCmd(CreateContainerConfig config) {
        Preconditions.checkNotNull((Object)config, (Object)"config was not specified");
        this.containerCreateConfig = config;
    }

    public CreateContainerCmd withImage(String image) {
        Preconditions.checkNotNull((Object)image, (Object)"image was not specified");
        this.containerCreateConfig.withImage(image);
        return this;
    }

    public CreateContainerCmd withCmd(String ... cmd) {
        Preconditions.checkNotNull((Object)cmd, (Object)"cmd was not specified");
        this.containerCreateConfig.withCmd(cmd);
        return this;
    }

    public CreateContainerCmd withVolumes(Volume ... volumes) {
        Preconditions.checkNotNull((Object)volumes, (Object)"volumes was not specified");
        this.containerCreateConfig.withVolumes(volumes);
        return this;
    }

    public CreateContainerCmd withName(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name was not specified");
        this.name = name;
        return this;
    }

    public CreateContainerCmd withExposedPorts(ExposedPort ... exposedPorts) {
        Preconditions.checkNotNull((Object)exposedPorts, (Object)"exposedPorts was not specified");
        this.containerCreateConfig.withExposedPorts(exposedPorts);
        return this;
    }

    @Override
    protected ContainerCreateResponse impl() {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        if (this.name != null) {
            params.add((Object)"name", (Object)this.name);
        }
        WebResource webResource = this.baseResource.path("/containers/create").queryParams((MultivaluedMap)params);
        try {
            LOGGER.trace("POST: {} ", (Object)webResource);
            return (ContainerCreateResponse)((WebResource.Builder)webResource.accept(new String[]{"application/json"}).type("application/json")).post(ContainerCreateResponse.class, (Object)this.containerCreateConfig);
        }
        catch (UniformInterfaceException exception) {
            if (exception.getResponse().getStatus() == 404) {
                throw new NotFoundException(String.format("%s is an unrecognized image. Please pull the image first.", this.containerCreateConfig.getImage()));
            }
            if (exception.getResponse().getStatus() == 406) {
                throw new DockerException("impossible to attach (container not running)");
            }
            if (exception.getResponse().getStatus() == 500) {
                throw new DockerException("Server error", exception);
            }
            throw new DockerException(exception);
        }
    }
}

