/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client.command;

import com.github.dockerjava.client.DockerException;
import com.github.dockerjava.client.command.AbstrDockerCmd;
import com.github.dockerjava.client.model.ImageCreateResponse;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.InputStream;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportImageCmd
extends AbstrDockerCmd<ImportImageCmd, ImageCreateResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportImageCmd.class);
    private String repository;
    private String tag;
    private InputStream imageStream;

    public ImportImageCmd(String repository, InputStream imageStream) {
        this.withRepository(repository);
        this.withImageStream(imageStream);
    }

    public ImportImageCmd withRepository(String repository) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository was not specified");
        this.repository = repository;
        return this;
    }

    public ImportImageCmd withImageStream(InputStream imageStream) {
        Preconditions.checkNotNull((Object)imageStream, (Object)"imageStream was not specified");
        this.imageStream = imageStream;
        return this;
    }

    public ImportImageCmd withTag(String tag) {
        Preconditions.checkNotNull((Object)tag, (Object)"tag was not specified");
        this.tag = tag;
        return this;
    }

    @Override
    protected ImageCreateResponse impl() {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"repo", (Object)this.repository);
        params.add((Object)"tag", (Object)this.tag);
        params.add((Object)"fromSrc", (Object)"-");
        WebResource webResource = this.baseResource.path("/images/create").queryParams((MultivaluedMap)params);
        try {
            LOGGER.trace("POST: {}", (Object)webResource);
            return (ImageCreateResponse)webResource.accept(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}).post(ImageCreateResponse.class, (Object)this.imageStream);
        }
        catch (UniformInterfaceException exception) {
            if (exception.getResponse().getStatus() == 500) {
                throw new DockerException("Server error.", exception);
            }
            throw new DockerException(exception);
        }
    }
}

