/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client.command;

import com.github.dockerjava.client.DockerException;
import com.github.dockerjava.client.NotFoundException;
import com.github.dockerjava.client.command.AbstrDockerCmd;
import com.github.dockerjava.client.model.ContainerInspectResponse;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InspectContainerCmd
extends AbstrDockerCmd<InspectContainerCmd, ContainerInspectResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InspectContainerCmd.class);
    private String containerId;

    public InspectContainerCmd(String containerId) {
        this.withContainerId(containerId);
    }

    public InspectContainerCmd withContainerId(String containerId) {
        Preconditions.checkNotNull((Object)containerId, (Object)"containerId was not specified");
        this.containerId = containerId;
        return this;
    }

    @Override
    protected ContainerInspectResponse impl() throws DockerException {
        WebResource webResource = this.baseResource.path(String.format("/containers/%s/json", this.containerId));
        try {
            LOGGER.trace("GET: {}", (Object)webResource);
            return (ContainerInspectResponse)webResource.accept(new String[]{"application/json"}).get(ContainerInspectResponse.class);
        }
        catch (UniformInterfaceException exception) {
            if (exception.getResponse().getStatus() == 404) {
                throw new NotFoundException(String.format("No such container %s", this.containerId));
            }
            if (exception.getResponse().getStatus() == 500) {
                throw new DockerException("Server error", exception);
            }
            throw new DockerException(exception);
        }
    }
}

