/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client.command;

import com.github.dockerjava.client.DockerException;
import com.github.dockerjava.client.NotFoundException;
import com.github.dockerjava.client.command.AbstrDockerCmd;
import com.github.dockerjava.client.model.ImageInspectResponse;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InspectImageCmd
extends AbstrDockerCmd<InspectImageCmd, ImageInspectResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InspectImageCmd.class);
    private String imageId;

    public InspectImageCmd(String imageId) {
        this.withImageId(imageId);
    }

    public InspectImageCmd withImageId(String imageId) {
        Preconditions.checkNotNull((Object)imageId, (Object)"imageId was not specified");
        this.imageId = imageId;
        return this;
    }

    @Override
    protected ImageInspectResponse impl() {
        WebResource webResource = this.baseResource.path(String.format("/images/%s/json", this.imageId));
        try {
            LOGGER.trace("GET: {}", (Object)webResource);
            return (ImageInspectResponse)webResource.accept(new String[]{"application/json"}).get(ImageInspectResponse.class);
        }
        catch (UniformInterfaceException exception) {
            if (exception.getResponse().getStatus() == 404) {
                throw new NotFoundException(String.format("No such image %s", this.imageId));
            }
            if (exception.getResponse().getStatus() == 500) {
                throw new DockerException("Server error", exception);
            }
            throw new DockerException(exception);
        }
    }
}

