/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client.command;

import com.github.dockerjava.client.DockerException;
import com.github.dockerjava.client.command.AbstrDockerCmd;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KillContainerCmd
extends AbstrDockerCmd<KillContainerCmd, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KillContainerCmd.class);
    private String containerId;

    public KillContainerCmd(String containerId) {
        this.withContainerId(containerId);
    }

    public KillContainerCmd withContainerId(String containerId) {
        Preconditions.checkNotNull((Object)containerId, (Object)"containerId was not specified");
        this.containerId = containerId;
        return this;
    }

    @Override
    protected Void impl() throws DockerException {
        WebResource webResource = this.baseResource.path(String.format("/containers/%s/kill", this.containerId));
        try {
            LOGGER.trace("POST: {}", (Object)webResource);
            ((WebResource.Builder)webResource.accept(new String[]{"application/json"}).type("application/json")).post();
        }
        catch (UniformInterfaceException exception) {
            if (exception.getResponse().getStatus() == 404) {
                LOGGER.warn("No such container {}", (Object)this.containerId);
            }
            if (exception.getResponse().getStatus() == 204) {
                LOGGER.trace("Successfully killed container {}", (Object)this.containerId);
            }
            if (exception.getResponse().getStatus() == 500) {
                throw new DockerException("Server error", exception);
            }
            throw new DockerException(exception);
        }
        return null;
    }
}

