/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client.command;

import com.github.dockerjava.client.command.AbstrDockerCmd;
import com.github.dockerjava.client.model.Container;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListContainersCmd
extends AbstrDockerCmd<ListContainersCmd, List<Container>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListContainersCmd.class);
    private int limit = -1;
    private boolean showSize;
    private boolean showAll = false;
    String sinceId;
    String beforeId;

    public ListContainersCmd withShowAll(boolean showAll) {
        this.showAll = showAll;
        return this;
    }

    public ListContainersCmd withShowSize(boolean showSize) {
        this.showSize = showSize;
        return this;
    }

    public ListContainersCmd withLimit(int limit) {
        Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0, (Object)"limit must be greater 0");
        this.limit = limit;
        return this;
    }

    public ListContainersCmd withSince(String since) {
        Preconditions.checkNotNull((Object)since, (Object)"since was not specified");
        this.sinceId = since;
        return this;
    }

    public ListContainersCmd withBefore(String before) {
        Preconditions.checkNotNull((Object)before, (Object)"before was not specified");
        this.beforeId = before;
        return this;
    }

    @Override
    protected List<Container> impl() {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        if (this.limit >= 0) {
            params.add((Object)"limit", (Object)String.valueOf(this.limit));
        }
        params.add((Object)"all", (Object)(this.showAll ? "1" : "0"));
        params.add((Object)"since", (Object)this.sinceId);
        params.add((Object)"before", (Object)this.beforeId);
        params.add((Object)"size", (Object)(this.showSize ? "1" : "0"));
        WebResource webResource = this.baseResource.path("/containers/json").queryParams((MultivaluedMap)params);
        LOGGER.trace("GET: {}", (Object)webResource);
        List containers = (List)webResource.accept(new String[]{"application/json"}).get((GenericType)new GenericType<List<Container>>(){});
        LOGGER.trace("Response: {}", (Object)containers);
        return containers;
    }
}

