/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client.command;

import com.github.dockerjava.client.DockerException;
import com.github.dockerjava.client.command.AbstrDockerCmd;
import com.github.dockerjava.client.model.Image;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListImagesCmd
extends AbstrDockerCmd<ListImagesCmd, List<Image>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListImagesCmd.class);
    private String filter;
    private boolean showAll = false;

    public ListImagesCmd withShowAll(boolean showAll) {
        this.showAll = showAll;
        return this;
    }

    public ListImagesCmd withFilter(String filter) {
        Preconditions.checkNotNull((Object)filter, (Object)"filter was not specified");
        this.filter = filter;
        return this;
    }

    @Override
    protected List<Image> impl() {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"filter", (Object)this.filter);
        params.add((Object)"all", (Object)(this.showAll ? "1" : "0"));
        WebResource webResource = this.baseResource.path("/images/json").queryParams((MultivaluedMap)params);
        try {
            LOGGER.trace("GET: {}", (Object)webResource);
            List images = (List)webResource.accept(new String[]{"application/json"}).get((GenericType)new GenericType<List<Image>>(){});
            LOGGER.trace("Response: {}", (Object)images);
            return images;
        }
        catch (UniformInterfaceException exception) {
            if (exception.getResponse().getStatus() == 400) {
                throw new DockerException("bad parameter");
            }
            if (exception.getResponse().getStatus() == 500) {
                throw new DockerException("Server error", exception);
            }
            throw new DockerException();
        }
    }
}

