/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client.command;

import com.github.dockerjava.client.DockerException;
import com.github.dockerjava.client.NotFoundException;
import com.github.dockerjava.client.command.AbstrDockerCmd;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogContainerCmd
extends AbstrDockerCmd<LogContainerCmd, ClientResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogContainerCmd.class);
    private String containerId;
    private boolean followStream;
    private boolean timestamps;
    private boolean stdout;
    private boolean stderr;

    public LogContainerCmd(String containerId) {
        this.withContainerId(containerId);
    }

    public LogContainerCmd withContainerId(String containerId) {
        Preconditions.checkNotNull((Object)containerId, (Object)"containerId was not specified");
        this.containerId = containerId;
        return this;
    }

    public LogContainerCmd withFollowStream() {
        return this.withFollowStream(true);
    }

    public LogContainerCmd withFollowStream(boolean followStream) {
        this.followStream = followStream;
        return this;
    }

    public LogContainerCmd withTimestamps(boolean timestamps) {
        this.timestamps = timestamps;
        return this;
    }

    public LogContainerCmd withStdOut() {
        return this.withStdOut(true);
    }

    public LogContainerCmd withStdOut(boolean stdout) {
        this.stdout = stdout;
        return this;
    }

    public LogContainerCmd withStdErr() {
        return this.withStdErr(true);
    }

    public LogContainerCmd withStdErr(boolean stderr) {
        this.stderr = stderr;
        return this;
    }

    @Override
    protected ClientResponse impl() throws DockerException {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"timestamps", (Object)(this.timestamps ? "1" : "0"));
        params.add((Object)"stdout", (Object)(this.stdout ? "1" : "0"));
        params.add((Object)"stderr", (Object)(this.stderr ? "1" : "0"));
        params.add((Object)"follow", (Object)(this.followStream ? "1" : "0"));
        WebResource webResource = this.baseResource.path(String.format("/containers/%s/logs", this.containerId)).queryParams((MultivaluedMap)params);
        try {
            LOGGER.trace("GET: {}", (Object)webResource);
            return (ClientResponse)webResource.accept(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}).get(ClientResponse.class);
        }
        catch (UniformInterfaceException exception) {
            if (exception.getResponse().getStatus() == 400) {
                throw new DockerException("bad parameter");
            }
            if (exception.getResponse().getStatus() == 404) {
                throw new NotFoundException(String.format("No such container %s", this.containerId));
            }
            if (exception.getResponse().getStatus() == 500) {
                throw new DockerException("Server error", exception);
            }
            throw new DockerException(exception);
        }
    }
}

