/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client.command;

import com.github.dockerjava.client.DockerException;
import com.github.dockerjava.client.command.AbstrDockerCmd;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullImageCmd
extends AbstrDockerCmd<PullImageCmd, ClientResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PullImageCmd.class);
    private String repository;
    private String tag;
    private String registry;

    public PullImageCmd(String repository) {
        this.withRepository(repository);
    }

    public PullImageCmd withRepository(String repository) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository was not specified");
        this.repository = repository;
        return this;
    }

    public PullImageCmd withTag(String tag) {
        Preconditions.checkNotNull((Object)tag, (Object)"tag was not specified");
        this.tag = tag;
        return this;
    }

    public PullImageCmd withRegistry(String registry) {
        Preconditions.checkNotNull((Object)registry, (Object)"registry was not specified");
        this.registry = registry;
        return this;
    }

    @Override
    protected ClientResponse impl() {
        Preconditions.checkNotNull((Object)this.repository, (Object)"Repository was not specified");
        if (StringUtils.countMatches((String)this.repository, (String)":") == 1) {
            String[] repositoryTag = StringUtils.split((String)this.repository, (char)':');
            this.repository = repositoryTag[0];
            this.tag = repositoryTag[1];
        }
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"tag", (Object)this.tag);
        params.add((Object)"fromImage", (Object)this.repository);
        params.add((Object)"registry", (Object)this.registry);
        WebResource webResource = this.baseResource.path("/images/create").queryParams((MultivaluedMap)params);
        try {
            LOGGER.trace("POST: {}", (Object)webResource);
            return (ClientResponse)webResource.accept(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}).post(ClientResponse.class);
        }
        catch (UniformInterfaceException exception) {
            if (exception.getResponse().getStatus() == 500) {
                throw new DockerException("Server error.", exception);
            }
            throw new DockerException(exception);
        }
    }
}

