/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client.command;

import com.github.dockerjava.client.DockerException;
import com.github.dockerjava.client.command.AbstrAuthCfgDockerCmd;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushImageCmd
extends AbstrAuthCfgDockerCmd<PushImageCmd, ClientResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PushImageCmd.class);
    private String name;

    public PushImageCmd(String name) {
        this.withName(name);
    }

    public PushImageCmd withName(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name was not specified");
        this.name = name;
        return this;
    }

    @Override
    protected ClientResponse impl() {
        WebResource webResource = this.baseResource.path("/images/" + this.name(this.name) + "/push");
        try {
            String registryAuth = this.registryAuth();
            LOGGER.trace("POST: {}", (Object)webResource);
            return (ClientResponse)((WebResource.Builder)webResource.header("X-Registry-Auth", (Object)registryAuth).accept(new String[]{"application/json"})).post(ClientResponse.class);
        }
        catch (UniformInterfaceException e) {
            throw new DockerException(e);
        }
    }

    private String name(String name) {
        return name.contains("/") ? name : this.authConfig.getUsername();
    }
}

