/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client.command;

import com.github.dockerjava.client.DockerException;
import com.github.dockerjava.client.command.AbstrDockerCmd;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveContainerCmd
extends AbstrDockerCmd<RemoveContainerCmd, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoveContainerCmd.class);
    private String containerId;
    private boolean removeVolumes;
    private boolean force;

    public RemoveContainerCmd(String containerId) {
        this.withContainerId(containerId);
    }

    public RemoveContainerCmd withContainerId(String containerId) {
        Preconditions.checkNotNull((Object)containerId, (Object)"containerId was not specified");
        this.containerId = containerId;
        return this;
    }

    public RemoveContainerCmd withRemoveVolumes(boolean removeVolumes) {
        this.removeVolumes = removeVolumes;
        return this;
    }

    public RemoveContainerCmd withForce() {
        return this.withForce(true);
    }

    public RemoveContainerCmd withForce(boolean force) {
        this.force = force;
        return this;
    }

    @Override
    protected Void impl() throws DockerException {
        Preconditions.checkState((!StringUtils.isEmpty((String)this.containerId) ? 1 : 0) != 0, (Object)"Container ID can't be empty");
        WebResource webResource = this.baseResource.path("/containers/" + this.containerId).queryParam("v", this.removeVolumes ? "1" : "0").queryParam("force", this.force ? "1" : "0");
        try {
            LOGGER.trace("DELETE: {}", (Object)webResource);
            String response = (String)webResource.accept(new String[]{"application/json"}).delete(String.class);
            LOGGER.trace("Response: {}", (Object)response);
        }
        catch (UniformInterfaceException exception) {
            if (exception.getResponse().getStatus() == 204) {
                LOGGER.trace("Successfully removed container " + this.containerId);
            }
            if (exception.getResponse().getStatus() == 400) {
                throw new DockerException("bad parameter");
            }
            if (exception.getResponse().getStatus() == 404) {
                LOGGER.warn(String.format("%s is an unrecognized container.", this.containerId));
            }
            if (exception.getResponse().getStatus() == 500) {
                throw new DockerException("Server error", exception);
            }
            throw new DockerException(exception);
        }
        return null;
    }
}

