/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client.command;

import com.github.dockerjava.client.DockerException;
import com.github.dockerjava.client.command.AbstrDockerCmd;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveImageCmd
extends AbstrDockerCmd<RemoveImageCmd, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoveImageCmd.class);
    private String imageId;
    private boolean force;
    private boolean noPrune;

    public RemoveImageCmd(String imageId) {
        this.withImageId(imageId);
    }

    public RemoveImageCmd withImageId(String imageId) {
        Preconditions.checkNotNull((Object)imageId, (Object)"imageId was not specified");
        this.imageId = imageId;
        return this;
    }

    public RemoveImageCmd withForce(boolean force) {
        this.force = force;
        return this;
    }

    public RemoveImageCmd withNoPrune(boolean noPrune) {
        this.noPrune = noPrune;
        return this;
    }

    @Override
    protected Void impl() throws DockerException {
        Preconditions.checkState((!StringUtils.isEmpty((String)this.imageId) ? 1 : 0) != 0, (Object)"Image ID can't be empty");
        try {
            WebResource webResource = this.baseResource.path("/images/" + this.imageId).queryParam("force", this.force ? "1" : "0").queryParam("noprune", this.noPrune ? "1" : "0");
            LOGGER.trace("DELETE: {}", (Object)webResource);
            webResource.delete(ClientResponse.class);
        }
        catch (UniformInterfaceException exception) {
            if (exception.getResponse().getStatus() == 204) {
                LOGGER.trace("Successfully removed image " + this.imageId);
            }
            if (exception.getResponse().getStatus() == 404) {
                LOGGER.warn("{} no such image", (Object)this.imageId);
            }
            if (exception.getResponse().getStatus() == 409) {
                throw new DockerException("Conflict");
            }
            if (exception.getResponse().getStatus() == 500) {
                throw new DockerException("Server error.", exception);
            }
            throw new DockerException(exception);
        }
        return null;
    }
}

