/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client.command;

import com.github.dockerjava.client.DockerException;
import com.github.dockerjava.client.NotFoundException;
import com.github.dockerjava.client.command.AbstrDockerCmd;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartContainerCmd
extends AbstrDockerCmd<RestartContainerCmd, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestartContainerCmd.class);
    private String containerId;
    private int timeout = 10;

    public RestartContainerCmd(String containerId) {
        this.withContainerId(containerId);
    }

    public RestartContainerCmd withContainerId(String containerId) {
        Preconditions.checkNotNull((Object)containerId, (Object)"containerId was not specified");
        this.containerId = containerId;
        return this;
    }

    public RestartContainerCmd withtTimeout(int timeout) {
        Preconditions.checkArgument((timeout >= 0 ? 1 : 0) != 0, (Object)"timeout must be greater or equal 0");
        this.timeout = timeout;
        return this;
    }

    @Override
    protected Void impl() throws DockerException {
        WebResource webResource = this.baseResource.path(String.format("/containers/%s/restart", this.containerId)).queryParam("t", String.valueOf(this.timeout));
        try {
            LOGGER.trace("POST: {}", (Object)webResource);
            ((WebResource.Builder)webResource.accept(new String[]{"application/json"}).type("application/json")).post();
        }
        catch (UniformInterfaceException exception) {
            if (exception.getResponse().getStatus() == 404) {
                throw new NotFoundException(String.format("No such container %s", this.containerId));
            }
            if (exception.getResponse().getStatus() == 204) {
                LOGGER.trace("Successfully restarted container {}", (Object)this.containerId);
            }
            if (exception.getResponse().getStatus() == 500) {
                throw new DockerException("Server error", exception);
            }
            throw new DockerException(exception);
        }
        return null;
    }
}

