/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client.command;

import com.github.dockerjava.client.DockerException;
import com.github.dockerjava.client.command.AbstrDockerCmd;
import com.github.dockerjava.client.model.SearchItem;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchImagesCmd
extends AbstrDockerCmd<SearchImagesCmd, List<SearchItem>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchImagesCmd.class);
    private String term;

    public SearchImagesCmd(String term) {
        this.withTerm(term);
    }

    public SearchImagesCmd withTerm(String term) {
        Preconditions.checkNotNull((Object)term, (Object)"term was not specified");
        this.term = term;
        return this;
    }

    @Override
    protected List<SearchItem> impl() {
        WebResource webResource = this.baseResource.path("/images/search").queryParam("term", this.term);
        try {
            LOGGER.trace("GET: {}", (Object)webResource);
            return (List)webResource.accept(new String[]{"application/json"}).get((GenericType)new GenericType<List<SearchItem>>(){});
        }
        catch (UniformInterfaceException exception) {
            if (exception.getResponse().getStatus() == 500) {
                throw new DockerException("Server error.", exception);
            }
            throw new DockerException(exception);
        }
    }
}

