/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client.command;

import com.github.dockerjava.client.DockerException;
import com.github.dockerjava.client.NotFoundException;
import com.github.dockerjava.client.command.AbstrDockerCmd;
import com.github.dockerjava.client.model.Bind;
import com.github.dockerjava.client.model.LxcConf;
import com.github.dockerjava.client.model.Ports;
import com.github.dockerjava.client.model.StartContainerConfig;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartContainerCmd
extends AbstrDockerCmd<StartContainerCmd, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartContainerCmd.class);
    private String containerId;
    private StartContainerConfig startContainerConfig = new StartContainerConfig();

    public StartContainerCmd(String containerId) {
        this.withContainerId(containerId);
    }

    public StartContainerCmd withBinds(Bind ... binds) {
        this.startContainerConfig.setBinds(binds);
        return this;
    }

    public StartContainerCmd withLxcConf(LxcConf[] lxcConf) {
        this.startContainerConfig.setLxcConf(lxcConf);
        return this;
    }

    public StartContainerCmd withPortBindings(Ports portBindings) {
        this.startContainerConfig.setPortBindings(portBindings);
        return this;
    }

    public StartContainerCmd withPrivileged(boolean privileged) {
        this.startContainerConfig.setPrivileged(privileged);
        return this;
    }

    public StartContainerCmd withPublishAllPorts(boolean publishAllPorts) {
        this.startContainerConfig.setPublishAllPorts(publishAllPorts);
        return this;
    }

    public StartContainerCmd withDns(String dns) {
        this.startContainerConfig.setDns(dns);
        return this;
    }

    public StartContainerCmd withVolumesFrom(String volumesFrom) {
        this.startContainerConfig.setVolumesFrom(volumesFrom);
        return this;
    }

    public StartContainerCmd withContainerId(String containerId) {
        Preconditions.checkNotNull((Object)containerId, (Object)"containerId was not specified");
        this.containerId = containerId;
        return this;
    }

    @Override
    protected Void impl() throws DockerException {
        WebResource webResource = this.baseResource.path(String.format("/containers/%s/start", this.containerId));
        try {
            LOGGER.trace("POST: {}", (Object)webResource);
            WebResource.Builder builder = webResource.accept(new String[]{"text/plain"});
            if (this.startContainerConfig != null) {
                ((WebResource.Builder)builder.type("application/json")).post((Object)this.startContainerConfig);
            } else {
                builder.post((Object)null);
            }
        }
        catch (UniformInterfaceException exception) {
            if (exception.getResponse().getStatus() == 404) {
                throw new NotFoundException(String.format("No such container %s", this.containerId));
            }
            if (exception.getResponse().getStatus() == 204) {
                LOGGER.trace("Successfully started container {}", (Object)this.containerId);
            }
            if (exception.getResponse().getStatus() == 500) {
                LOGGER.error("", (Throwable)exception);
                throw new DockerException("Server error", exception);
            }
            throw new DockerException(exception);
        }
        return null;
    }
}

