/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client.command;

import com.github.dockerjava.client.DockerException;
import com.github.dockerjava.client.command.AbstrDockerCmd;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import javax.ws.rs.core.MultivaluedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagImageCmd
extends AbstrDockerCmd<TagImageCmd, Integer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TagImageCmd.class);
    private String imageId;
    private String repository;
    private String tag;
    private boolean force;

    public TagImageCmd(String imageId, String repository, String tag) {
        this.withImageId(imageId);
        this.withRepository(repository);
        this.withTag(tag);
    }

    public TagImageCmd withImageId(String imageId) {
        Preconditions.checkNotNull((Object)imageId, (Object)"imageId was not specified");
        this.imageId = imageId;
        return this;
    }

    public TagImageCmd withRepository(String repository) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository was not specified");
        this.repository = repository;
        return this;
    }

    public TagImageCmd withTag(String tag) {
        Preconditions.checkNotNull((Object)tag, (Object)"tag was not specified");
        this.tag = tag;
        return this;
    }

    public TagImageCmd withForce() {
        return this.withForce(true);
    }

    public TagImageCmd withForce(boolean force) {
        this.force = force;
        return this;
    }

    @Override
    protected Integer impl() {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"repo", (Object)this.repository);
        params.add((Object)"tag", (Object)this.tag);
        params.add((Object)"force", (Object)(this.force ? "1" : "0"));
        WebResource webResource = this.baseResource.path("/images/" + this.imageId + "/tag").queryParams((MultivaluedMap)params);
        try {
            LOGGER.trace("POST: {}", (Object)webResource);
            ClientResponse resp = (ClientResponse)webResource.post(ClientResponse.class);
            return resp.getStatus();
        }
        catch (UniformInterfaceException exception) {
            throw new DockerException(exception);
        }
    }
}

